% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memory.R
\docType{data}
\name{memory}
\alias{memory}
\title{Memory data on health and schizophrenic patients}
\format{
A data.frame with 40 rows and 8 columns.
}
\usage{
data(memory)
}
\description{
Data set from study assessing differences between schizophrenic patients and
healthy control participants in patterns of correlations among 6 verbal memory
tasks (Ichinose et al., 2019).
\tabular{lll}{
   \strong{Im} \tab \code{numeric} \tab Percent correct on immediate recall of 3 word lists\cr
   \strong{Del} \tab \code{numeric} \tab Percent correct on delayed recall of 3 word lists\cr
   \strong{Wmn} \tab \code{numeric} \tab Number correct on letter-number span test of auditory working memory\cr
   \strong{Cat} \tab \code{numeric} \tab Number correct on category fluency task\cr
   \strong{Fas} \tab \code{numeric} \tab Number correct on letter fluency task\cr
   \strong{Rat} \tab \code{numeric} \tab Number correct on remote associates task\cr
   \strong{Group} \tab \code{factor} \tab Participant Group (HC = Healthy Control; SZ = Schizophrenia) \cr
}
}
\references{
Ichinose, M.C., Han, G., Polyn, S., Park, S., & Tomarken, A.J. (2019). Verbal memory performance discordance in schizophrenia: A reflection of cognitive dysconnectivity.
Unpublished manuscript.
}
\keyword{datasets}
