% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{mse}
\alias{mse}
\title{Mean Squared Error}
\usage{
mse(object, ...)
}
\arguments{
\item{object}{object of class \code{post.pred} or  \code{predict.estimate}}

\item{...}{currently ignored}
}
\value{
object of class \code{metric}
}
\description{
Compute mean squared error for either the observed data or future data. The former
is computed by plugging in the observed y (the predicted node). The latter is computed from
replicated data sets (posterior predictive y), which results in the posterior predictive
mean squared error.  Both provide a measure of uncertainty,  as the error is computed from
the posterior samples. However, the posterior predictive approach fully captures uncertainty.
}
\examples{
# data
Y <- subset(tas, gender == "M")[,-ncol(tas)]

# fit model
fit <- estimate(Y)

# predict (note summary = FALSE)
pred <- predict(fit, iter = 50, summary = FALSE)

mse(pred)
}
