% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSBHaz.R
\name{BSBHaz}
\alias{BSBHaz}
\title{BSBHaz posterior samples using Gibbs Sampler}
\usage{
BSBHaz(
  bsb_init,
  iter,
  burn_in = 0,
  omega_d = NULL,
  gamma_d = NULL,
  theta_d = NULL,
  seed = 42
)
}
\arguments{
\item{bsb_init}{An object of class 'BSBinit' created by
\code{\link{BSBInit}}.}

\item{iter}{A positive integer. Number of samples generated by the Gibbs
Sampler.}

\item{burn_in}{A positive integer. Number of iterations that should be
discarded as burn in period.}

\item{omega_d}{A positive double. This parameter defines the interval used in
the Metropolis-Hastings algorithm to sample proposals for omega. See
details.}

\item{gamma_d}{A positive double. This parameter defines the interval used in
the Metropolis-Hastings algorithm to sample proposals for gamma. See
details.}

\item{theta_d}{A positive double. This parameter defines the interval used in
the Metropolis-Hastings algorithm to sample proposals for theta. See
details.}

\item{seed}{Random seed used in sampling.}
}
\value{
An object of class '\code{BSBHaz}' containing the samples from the
  variables of interest.
}
\description{
\code{BSBHaz} samples posterior observations from the bivariate survival
model (BSBHaz model) proposed by Nieto-Barajas & Walker (2007).
}
\details{
BSBHaz (Nieto-Barajas & Walker, 2007) is a bayesian semiparametric model for
bivariate survival data. The marginal densities are nonparametric survival
models and the joint density is constructed via a mixture. Dependence between
failure times is modeled using two frailties, and the dependence between
these frailties is modeled with a copula.

This command obtains posterior samples from model parameters. The samples
from omega, gamma, and theta are obtained using the Metropolis-Hastings
algorithm. The proposal distributions are uniform for the three parameters.
The parameters \code{omega_d}, \code{gamma_d} and \code{theta_d} modify the
intervals from which the uniform proposals are sampled. If these parameters
are too large, the acceptance rates will decrease and the chains will get
stuck. On the other hand, if these parameters are small, the acceptance rates
will be too high and the chains will not explore the posterior support
effectively.
}
\examples{
t1 <- survival::Surv(c(1, 2, 3))
t2 <- survival::Surv(c(1, 2, 3))

init <- BSBInit(t1 = t1, t2 = t2, seed = 0)
samples <- BSBHaz(init, iter = 10, omega_d = 2,
gamma_d = 10, seed = 10)
}
