% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulatePedigree.R
\name{simulatePedigree}
\alias{simulatePedigree}
\title{Simulate Pedigrees
This function simulates "balanced" pedigrees based on a group of parameters:
1) k - Kids per couple;
2) G - Number of generations;
3) p - Proportion of males in offspring;
4) r - Mating rate.}
\usage{
simulatePedigree(
  kpc = 3,
  Ngen = 4,
  sexR = 0.5,
  marR = 2/3,
  rd_kpc = FALSE,
  balancedSex = TRUE,
  balancedMar = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{kpc}{Number of kids per couple. An integer >= 2 that determines how many kids each fertilized mated couple will have in the pedigree. Default value is 3. Returns an error when kpc equals 1.}

\item{Ngen}{Number of generations. An integer >= 2 that determines how many generations the simulated pedigree will have. The first generation is always a fertilized couple. The last generation has no mated individuals.}

\item{sexR}{Sex ratio of offspring. A numeric value ranging from 0 to 1 that determines the proportion of males in all offspring in this pedigree. For instance, 0.4 means 40 percent of the offspring will be male.}

\item{marR}{Mating rate. A numeric value ranging from 0 to 1 which determines the proportion of mated (fertilized) couples in the pedigree within each generation. For instance, marR = 0.5 suggests 50 percent of the offspring in a specific generation will be mated and have their offspring.}

\item{rd_kpc}{logical. If TRUE, the number of kids per mate will be randomly generated from a poisson distribution with mean kpc. If FALSE, the number of kids per mate will be fixed at kpc.}

\item{balancedSex}{Not fully developed yet. Always \code{TRUE} in the current version.}

\item{balancedMar}{Not fully developed yet. Always \code{TRUE} in the current version.}

\item{verbose}{logical  If TRUE, print progress through stages of algorithm}
}
\value{
A \code{data.frame} with each row representing a simulated individual. The columns are as follows:
\itemize{
  \item{fam: The family id of each simulated individual. It is 'fam1' in a single simulated pedigree.}
  \item{ID: The unique personal ID of each simulated individual. The first digit is the fam id; the fourth digit is the generation the individual is in; the following digits represent the order of the individual within his/her pedigree. For example, 100411 suggests this individual has a family id of 1, is in the 4th generation, and is the 11th individual in the 4th generation.}
  \item{gen: The generation the simulated individual is in.}
  \item{dadID: Personal ID of the individual's father.}
  \item{momID: Personal ID of the individual's mother.}
  \item{spID: Personal ID of the individual's mate.}
  \item{sex: Biological sex of the individual. F - female; M - male.}
}
}
\description{
Simulate Pedigrees
This function simulates "balanced" pedigrees based on a group of parameters:
1) k - Kids per couple;
2) G - Number of generations;
3) p - Proportion of males in offspring;
4) r - Mating rate.
}
