% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildPedigree.R
\name{ped2paternal}
\alias{ped2paternal}
\title{Add a paternal line ID variable to a pedigree}
\usage{
ped2paternal(
  ped,
  personID = "ID",
  momID = "momID",
  dadID = "dadID",
  patID = "patID",
  ...
)
}
\arguments{
\item{ped}{a pedigree dataset.  Needs ID, momID, and dadID columns}

\item{personID}{character.  Name of the column in ped for the person ID variable}

\item{momID}{character.  Name of the column in ped for the mother ID variable}

\item{dadID}{character.  Name of the column in ped for the father ID variable}

\item{patID}{Character.  Paternal line ID variable to be created and added to the pedigree}

\item{...}{additional arguments to be passed to \code{\link{ped2com}}}
}
\description{
Add a paternal line ID variable to a pedigree
}
\details{
Under various scenarios it is useful to know which people in a pedigree
belong to the same paternal lines.  This function first turns a pedigree
into a graph where adjacency is defined by father-child relationships.
Subsequently, the weakly connected components algorithm finds all the
separate paternal lines and gives them an ID variable.
}
\seealso{
[ped2fam()] for creating extended family IDs, and [ped2maternal()]
for creating maternal line IDs
}
