% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_list_country}
\alias{BIEN_list_country}
\title{Extract species list by country}
\usage{
BIEN_list_country(country, cultivated = FALSE, only.new.world = TRUE,
  print.query = FALSE, ...)
}
\arguments{
\item{country}{A single country or a vector of countries.}

\item{cultivated}{Return cultivated records as well?  Default is FALSE.}

\item{only.new.world}{Return only records from the New World?  Default is true}

\item{print.query}{Should the PostgreSQL query be printed? The default value is FALSE.}

\item{...}{Additional arguments passed to BIEN_sql}
}
\value{
Dataframe containing species list(s) for the specified country or countries.
}
\description{
BIEN_list_country downloads a list of all species within a country or countries from the BIEN database.
}
\examples{
\dontrun{
BIEN_list_country("Canada")
country_vector<-c("Canada","United States")
BIEN_list_country(country_vector)}
}
\seealso{
Other list functions: \code{\link{BIEN_list_all}},
  \code{\link{BIEN_list_county}},
  \code{\link{BIEN_list_shapefile}},
  \code{\link{BIEN_list_state}}
}

