% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_occurrence_family}
\alias{BIEN_occurrence_family}
\title{Extract species occurrences by family.}
\usage{
BIEN_occurrence_family(family, cultivated = FALSE, only.new.world = TRUE,
  print.query = FALSE, observation.type = FALSE, all.taxonomy = FALSE,
  native.status = FALSE, political.boundaries = FALSE, ...)
}
\arguments{
\item{family}{A single family or a vector of families.}

\item{cultivated}{Return cultivated records as well?  Default is FALSE.}

\item{only.new.world}{Return only records from the New World?  Default is true}

\item{print.query}{Should the PostgreSQL query be printed? The default value is FALSE.}

\item{observation.type}{Return information on type of observation (i.e. specimen vs. plot)?  The default value is FALSE.}

\item{all.taxonomy}{Return all taxonomic information?  This includes the raw data as well as the "scrubbed" data.}

\item{native.status}{Return information on introduction status?  The default value is FALSE. A value of TRUE also returns additional information on introduction status.}

\item{political.boundaries}{Return information on political boundaries for an observation? The default value is FALSE.}

\item{...}{Additional arguments passed to BIEN_sql}
}
\value{
Dataframe containing occurrence records for the specified family/families.
}
\description{
BIEN_occurrence_family extracts all occurrences for a given family (or families) from the BIEN database.
}
\examples{
\dontrun{
BIEN_occurrence_family("Theaceae")
family_vector<-c("Theaceae","Ericaceae")
BIEN_occurrence_family(family_vector)}
}
\seealso{
Other occurrence functions: \code{\link{BIEN_occurrence_box}},
  \code{\link{BIEN_occurrence_country}},
  \code{\link{BIEN_occurrence_county}},
  \code{\link{BIEN_occurrence_genus}},
  \code{\link{BIEN_occurrence_records_per_species}},
  \code{\link{BIEN_occurrence_shapefile}},
  \code{\link{BIEN_occurrence_species}},
  \code{\link{BIEN_occurrence_state}}
}

