% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIGDAWG.R
\name{BIGDAWG}
\alias{BIGDAWG}
\title{BIGDAWG wrapper function}
\usage{
BIGDAWG(Data, HLA = TRUE, Run.Tests, Loci.Set, All.Pairwise = FALSE,
  Trim = FALSE, Res = 2, EVS.rm = FALSE, Missing = 2, Cores.Lim = 1L,
  Results.Dir, Output = TRUE)
}
\arguments{
\item{Data}{Name of the genotype data file.}

\item{HLA}{Logical indicating whether data is HLA class I/II genotyping data only.}

\item{Run.Tests}{Specifics which tests to run.}

\item{Loci.Set}{Input list defining which loci to use for analyses (combinations permitted).}

\item{All.Pairwise}{Logical indicating whether all pairwise.}

\item{Trim}{Logical indicating if HLA alleles should be trimmed to a set resolution.}

\item{Res}{Numeric setting what desired resolution to trim HLA alleles.}

\item{EVS.rm}{Logical indicating if expression variant suffixes should be removed.}

\item{Missing}{Numeric setting allowable missing data for running analysis (may use "ignore").}

\item{Cores.Lim}{Interger setting the number of cores accessible to BIGDAWG (Windows, Cores = 1L).}

\item{Results.Dir}{Optional, full directory name for BIGDAWG output.}

\item{Output}{Logical indicating if data should be written to output directory (mainly used for testing).}
}
\description{
This is the main wrapper function for each analysis.
}
\examples{
### The following examples use the synthetic data set bundled with BIGDAWG

# Haplotype analysis with no missing genotypes for two loci
# Significant haplotypic association with phenotype 
BIGDAWG(Data="HLA_data", Run.Tests="H", Missing=0, Loci.Set=list(c("DRB1","DQB1")))

# Hardy-Weinberg and Locus analysis ignoring missing data
# Significant associations with phenotype at all but DQB1
BIGDAWG(Data="HLA_data", Run.Tests=c("HWE","L"), Missing="ignore")

# Hardy-Weinberg analysis trimming data to 2-Field resolution
# Significant deviation at DQB1
BIGDAWG(Data="HLA_data", Run.Tests="HWE", Trim=TRUE, Res=2)
}

