% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_temporal_betas}
\alias{plot_temporal_betas}
\title{Plot Temporal Beta Coefficients}
\usage{
plot_temporal_betas(
  bktr_reg,
  plot_feature_labels,
  spatial_point_label,
  date_format = "\%Y-\%m-\%d",
  show_figure = TRUE,
  fig_width = 8.5,
  fig_height = 5.5,
  fig_resolution = 200
)
}
\arguments{
\item{bktr_reg}{BKTRRegressor: BKTRRegressor object.}

\item{plot_feature_labels}{Array: Array of feature labels to plot.}

\item{spatial_point_label}{String: Spatial point label to plot.}

\item{date_format}{String: Format of the date to use in bktr dataframes for the time.
Defaults to '\%Y-\%m-\%d'.}

\item{show_figure}{Boolean: Whether to show the figure. Defaults to True.}

\item{fig_width}{Numeric: Figure width when figure is shown. Defaults to 8.5.}

\item{fig_height}{Numeric: Figure height when figure is shown. Defaults to 5.5.}

\item{fig_resolution}{Numeric: Figure resolution PPI. Defaults to 200.}
}
\value{
ggplot or NULL: ggplot object or NULL if show_figure is set to FALSE.
}
\description{
Create a plot of the beta values through time for a given
spatial point and a set of feature labels.
}
\examples{
\dontshow{if (torch::torch_is_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Launch MCMC sampling on a light version of the BIXI dataset
bixi_data <- BixiData$new(is_light = TRUE)
bktr_regressor <- BKTRRegressor$new(
  data_df <- bixi_data$data_df,
  spatial_positions_df = bixi_data$spatial_positions_df,
  temporal_positions_df = bixi_data$temporal_positions_df,
  burn_in_iter = 5, sampling_iter = 10) # For example only (too few iterations)
bktr_regressor$mcmc_sampling()

# Plot temporal beta coefficients for the first station and the two features
plot_temporal_betas(
  bktr_regressor,
  plot_feature_labels = c('mean_temp_c', 'area_park'),
  spatial_point_label = bixi_data$spatial_positions_df$location[1])
\dontshow{\}) # examplesIf}
}
