% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_and_plot_results.R
\name{plot.BMRMMsummary}
\alias{plot.BMRMMsummary}
\title{Plot Method for Visualizing BMRMM Summary}
\usage{
\method{plot}{BMRMMsummary}(x, type, xlab = NULL, ylab = NULL, main = NULL, col = NULL, ...)
}
\arguments{
\item{x}{an object of class \code{BMRMMsummary}.}

\item{type}{a string indicating the plot(s) to draw. Must be named after a field of \code{object}.}

\item{xlab}{x-axis label. Default is NULL.}

\item{ylab}{y-axis label. Default is NULL.}

\item{main}{main title. Default is NULL.}

\item{col}{color of the plot. Default is NULL.}

\item{...}{further arguments for the plot function.}
}
\value{
None
}
\description{
Visualization of a specified field of a \code{BMRMMsummary} object.
}
\examples{
results <- BMRMM(foxp2sm, num.cov = 2, simsize = 50, 
                 cov.labels = list(c("F", "W"), c("U", "L", "A")),
                 duration.distr = list('mixgamma',shape=rep(1,3),rate=rep(1,3)))
fit.summary <- summary(results)
plot(fit.summary, 'trans.probs.mean')
plot(fit.summary, 'dur.mix.probs')

}
\seealso{
\code{\link[=summary.BMRMM]{summary.BMRMM()}}
}
