\name{datafls}
\alias{datafls}
\docType{data}
\title{FLS (2001) growth data}
\description{
 The economic growth data set from Fernandez, Ley and Steel, Journal of Applied Econometrics 2001
}
\usage{data(datafls)}
\format{
  A data frame with 72 observations on the following 42 variables.
  \describe{
    \item{\code{y}}{numeric: Economic growth 1960-1992 as from the Penn World Tables Rev 6.0}
    \item{\code{Abslat}}{numeric: Absolute latitude}
    \item{\code{Spanish}}{numeric: Spanish colony dummy}
    \item{\code{French}}{numeric: French colony dummy}
    \item{\code{Brit}}{numeric: British colony dummy}
    \item{\code{WarDummy}}{numeric: War dummy}
    \item{\code{LatAmerica}}{numeric: Latin America dummy}
    \item{\code{SubSahara}}{numeric; Sub-Sahara dummy}
    \item{\code{OutwarOr}}{numeric: Outward Orientation}
    \item{\code{Area}}{numeric: Area surface}
    \item{\code{PrScEnroll}}{numeric: Primary school enrolment}
    \item{\code{LifeExp}}{numeric: Life expectancy}
    \item{\code{GDP60}}{numeric: Initial GDP in 1960}
    \item{\code{Mining}}{numeric: Fraction of GDP in mining}
    \item{\code{EcoOrg}}{numeric: Degree of capitalism}
    \item{\code{YrsOpen}}{numeric: Number of years having an open economy}
    \item{\code{Age}}{numeric: Age}
    \item{\code{Buddha}}{numeric: Fraction Buddhist}
    \item{\code{Catholic}}{numeric: Fraction Catholic}
    \item{\code{Confucian}}{numeric: Fraction Confucian}
    \item{\code{EthnoL}}{numeric: Ethnolinguistic fractionalization}
    \item{\code{Hindu}}{numeric: Fraction Hindu}
    \item{\code{Jewish}}{numeric: Fraction Jewish}
    \item{\code{Muslim}}{numeric: Fraction Muslim}
    \item{\code{PrExports}}{numeric: Primary exports 1970}
    \item{\code{Protestants}}{numeric: Fraction Protestants}
    \item{\code{RuleofLaw}}{numeric: Rule of law}
    \item{\code{Popg}}{numeric: Population growth}
    \item{\code{WorkPop}}{numeric: workers per inhabitant}
    \item{\code{LabForce}}{numeric: Size of labor force}
    \item{\code{HighEnroll}}{numeric: Higher education enrolment}
    \item{\code{PublEdupct}}{numeric: Public education share}
    \item{\code{RevnCoup}}{numeric: Revolutions and coups}
    \item{\code{PolRights}}{numeric: Political rights}
    \item{\code{CivlLib}}{numeric: Civil liberties}
    \item{\code{English}}{numeric: Fraction speaking English}
    \item{\code{Foreign}}{numeric: Fraction speaking foreign language}
    \item{\code{RFEXDist}}{numeric: Exchange rate distortions}
    \item{\code{EquipInv}}{numeric: Equipment investment}
    \item{\code{NequipInv}}{numeric: Non-equipment investment}
    \item{\code{stdBMP}}{numeric: stand. dev. of black market premium}
    \item{\code{BlMktPm}}{numeric: black market premium}
  }
}
\source{
  Fernandez, C., Ley, E., and Steel, M. F. (2001b). Model Uncertainty in Cross-Country
Growth Regressions. Journal of Applied Econometrics, 16:563-576.
}
\references{
  Data set from \url{http://www2.warwick.ac.uk/fac/sci/statistics/staff/academic/steel/steel_homepage/software}
  A working paper version of Fernandez, Ley and Steel (2001) is available at \url{http://www2.warwick.ac.uk/fac/sci/statistics/staff/academic/steel/steel_homepage/software/fls3fin.pdf}
}
\examples{
data(datafls)
## maybe str(datafls) ; plot(datafls) ...
}
\keyword{datasets}
