% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmhyb.r
\name{AddHybridization}
\alias{AddHybridization}
\title{Add hybrid events to a phy.graph}
\usage{
AddHybridization(phy.graph, from.clade, to.clade, time.from.root = NULL,
  time.from.tip = NULL, ghost.length = 0)
}
\arguments{
\item{phy.graph}{An ape::evonet object (a phylogeny stored in phylo format that also includes a reticulation matrix)}

\item{from.clade}{A vector of names specifying taxa spanning the node descended from the focal edge for the start of the hybridization event}

\item{to.clade}{A vector of names specifying taxa spanning the node descended from the focal edge for the start of the hybridization event}

\item{time.from.root}{When the hybridization event starts, as measured from the root of the tree}

\item{time.from.tip}{When the hybridization event starts, as measured from the tips of the tree (assumed to be coeval)}

\item{ghost.length}{How long the hybrid genes spend in an unsampled species before arriving in their recipient}
}
\value{
An evonet object with the new hybridization event
}
\description{
Given an evonet object, and info on where the gene flow is from and to, and when this occurs, add a hybridization event. The edges things move from and to are specified by the list of descendant taxa of those edges (basically the edge is the subtending branch for the clade). You do not have to list all taxa, only those spanning the node at the end of the edge. You can enter a single taxon to have gene flow to or from a terminal branch. You also ideally will specify when the gene flow happens. This can be given as time from the root of the tree to when the event starts or time from the tip of the tree back to when the gene flow starts (but you must give one of these). If gene flow goes through an unsampled ghost intermediate, you can enter the length of time it spends there. If you do not specify any of these, flow is assumed to directly from the source to the recipient, with the time set at the start of the recent of the two branches (i.e., if flow goes from taxon A to taxon D, if D is younger the flow is assumed to happen partway up the terminal branch of A to directly connect to the start of D.
}
