% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GOFplots.R
\name{pp_plot_censored}
\alias{pp_plot_censored}
\title{Plot the percentile-percentile graph for non censored data, using the
Turnbull estimator the position of the percentiles.}
\usage{
pp_plot_censored(fit)
}
\arguments{
\item{fit}{The result of the fit, obtained through the function MixNRMI1cens
or MixNRMI2cens.}
}
\value{
Percentile-percentile graph using the Turnbull estimator
}
\description{
Plot the percentile-percentile graph for non censored data, using the
Turnbull estimator the position of the percentiles.
}
\examples{

set.seed(150520)
data(salinity)
out <- MixNRMI1cens(xleft = salinity$left, xright = salinity$right, extras = TRUE, Nit = 100)
BNPdensity:::pp_plot_censored(out)
}
