% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logit.R
\name{logit}
\alias{logit}
\title{Logit function}
\usage{
logit(pi)
}
\arguments{
\item{pi}{Numeric value on the interval \eqn{[0,1]} (usually a probability).}
}
\value{
Numeric value, result of \code{log(pi/(1-pi))}.
}
\description{
Logit function
}
\examples{
# probabilities 
prob_ICE_base <- 0.3
prob_ICE_risk <- 0.6
# model coefficients
(beta1 <- logit(prob_ICE_base))
(beta2 <- logit(prob_ICE_risk) - logit(prob_ICE_base))
# linear predictor 
logit(prob_ICE_base); (lin_pred1 <- beta1 + beta2*0)
logit(prob_ICE_risk); (lin_pred2 <- beta1 + beta2*1)
# inverse logit of linear predictor 
(inv_logit(lin_pred1)) # prob for X1 = 0
(inv_logit(lin_pred2)) # prob for X1 = 1
}
\seealso{
\code{\link[=inv_logit]{inv_logit()}}
}
