% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brvm-index-stock.R
\name{BRVM_index_stock}
\alias{BRVM_index_stock}
\title{BRVM index stock - Given a set of indexes, return their stock data}
\usage{
BRVM_index_stock(
  .ticker = "BRVM10",
  Period = 0,
  from = Sys.Date() - 89,
  to = Sys.Date()
)
}
\arguments{
\item{.ticker}{Must be at least one index between c("BRVM10","BRVMAG","BRVMC","BRVMAS","BRVMDI","BRVMFI", "BRVMIN", "BRVMSP", "BRVMTR")}

\item{Period}{Numeric number indicating time period. Valid entries are 0, 1, 5, 30, 91, and 365 representing respectively ‘daily’, 'one year', ‘weekly’, ‘monthly’, ‘quarterly’ and ‘yearly’ .}

\item{from}{A quoted start date, ie. "2020-01-01" or "2020/01/01". The date
must be in ymd format "YYYY-MM-DD" or "YYYY/MM/DD".}

\item{to}{A quoted end date, ie. "2022-05-20" or "2022/05/20". The date must
be in ymd format "YYYY-MM-DD" or "YYYY/MM/DD"}
}
\value{
"data.frame"
}
\description{
Give a set of indexes and get it/their stock data. Use BRVM.index() function to know all available indexes
}
\examples{
\donttest{
BRVM_index_stock(.ticker = "BRVMAG", from = "2018-01-04", to = "2022-01-04")

BRVM_index_stock("BRVM10", Period = 0, from = "2021-01-04", to = "2022-01-04"  ) #To get daily data

BRVM_index_stock("BrvmAS", Period = 1 ) # To get daily data for a whole year

BRVM_index_stock("BRVM10", Period = 5, from = "2021-01-04", to = "2022-01-04") # To get weekly data

BRVM_index_stock("BRVMAG", Period = 30 ) # To get monthly data

BRVM_index_stock("BRVM10", Period = 91 ) # To get quaterly data

BRVM_index_stock("brvmtr", Period = 365 ) # To get yearly data
}
}
\seealso{
\code{BRVM_get()}, \code{BRVM_get1()}

Other Data Retrieval: 
\code{\link{BRVM_bySector}()},
\code{\link{BRVM_cap}()},
\code{\link{BRVM_company_rank}()},
\code{\link{BRVM_get1}()},
\code{\link{BRVM_get}()},
\code{\link{BRVM_index}()},
\code{\link{BRVM_market_activity}()},
\code{\link{BRVM_plot}()},
\code{\link{BRVM_stock_market}()},
\code{\link{BRVM_ticker_desc}()},
\code{\link{company_cap}()},
\code{\link{company_country}()},
\code{\link{company_nbrank}()},
\code{\link{company_sector}()},
\code{\link{company_traded_val}()}

Other BRVM: 
\code{\link{BRVM.index}()},
\code{\link{BRVM_cap}()},
\code{\link{BRVM_company_cap}()},
\code{\link{BRVM_company_rank}()},
\code{\link{BRVM_company_url}()},
\code{\link{BRVM_index}()},
\code{\link{BRVM_market_activity}()},
\code{\link{BRVM_plot}()},
\code{\link{BRVM_stock_market}()},
\code{\link{BRVM_ticker_desc}()},
\code{\link{BRVM_traded_val}()},
\code{\link{company_cap}()},
\code{\link{company_country}()},
\code{\link{company_nbrank}()},
\code{\link{company_sector}()},
\code{\link{company_traded_val}()},
\code{\link{normality_test}()},
\code{\link{stationarity_test}()}
}
\author{
Koffi Frederic SESSIE
}
\concept{BRVM}
\concept{Data Retrieval}
