% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Appendec}
\alias{Appendec}
\title{Median costs of appendectomies at three different types of North Carolina
hospitals}
\format{
A data frame/tibble  with 59 observations on two variables
\describe{ 
\item{cost}{median costs of appendectomies at hospitals across the state of North Carolina in 1992} 
\item{region}{a vector classifying each hospital as rural, regional, or metropolitan} 
}
}
\source{
\emph{Consumer's Guide to Hospitalization Charges in North Carolina Hospitals}
(August 1994), North Carolina Medical Database Commission, Department of Insurance.
}
\usage{
Appendec
}
\description{
Data for Exercise 10.60
}
\examples{

boxplot(cost ~ region, data = Appendec, col = c("red", "blue", "cyan"))
anova(lm(cost ~ region, data = Appendec))

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
