% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Hodgkin}
\alias{Hodgkin}
\title{Results of treatments for Hodgkin's disease}
\format{
A data frame/tibble with 538 observations on two variables
\describe{ 
\item{type}{a factor with levels \code{LD},
\code{LP}, \code{MC}, and \code{NS}} 
\item{response}{a factor with levels \code{Positive}, \code{Partial}, and \code{None}}
}
}
\source{
I. Dunsmore, F. Daly, \emph{Statistical Methods, Unit 9, Categorical Data}, 
Milton Keynes, The Open University, 18.
}
\usage{
Hodgkin
}
\description{
Data for Exercise 2.77
}
\examples{

T1 <- xtabs(~type + response, data = Hodgkin)
T1
barplot(t(T1), legend = TRUE, beside = TRUE)

\dontrun{
library(ggplot2)
ggplot2::ggplot(data = Hodgkin, aes(x = type, fill = response)) + 
           geom_bar(position = "dodge") + 
           theme_bw()
}

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
