% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgnbd.R
\name{bgnbd.pmf}
\alias{bgnbd.pmf}
\title{BG/NBD Probability Mass Function}
\usage{
bgnbd.pmf(params, t, x)
}
\arguments{
\item{params}{BG/NBD parameters - a vector with r, alpha, a, and b, in that
order. r and alpha are unobserved parameters for the NBD transaction
process. a and b are unobserved parameters for the Beta geometric dropout
process.}

\item{t}{length end of time period for which probability is being computed.
May also be a vector.}

\item{x}{number of repeat transactions by a random customer in the period
defined by t. May also be a vector.}
}
\value{
Probability of X(t)=x conditional on model parameters. If t and/or x
has a length greater than one, a vector of probabilities will be returned.
}
\description{
Probability mass function for the BG/NBD.
}
\details{
P(X(t)=x | r, alpha, a, b). Returns the probability that a customer makes x
repeat transactions in the time interval (0, t].

Parameters t and x may be vectors. The standard rules for vector operations
apply - if they are not of the same length, the shorter vector will be
recycled (start over at the first element) until it is as long as the longest
vector. It is advisable to keep vectors to the same length and to use single
values for parameters that are to be the same for all calculations. If one of
these parameters has a length greater than one, the output will be a vector
of probabilities.
}
\examples{
params <- c(0.243, 4.414, 0.793, 2.426)
# probability that a customer will make 10 repeat transactions in the
# time interval (0,2]
bgnbd.pmf(params, t=2, x=10)
# probability that a customer will make no repeat transactions in the
# time interval (0,39]
bgnbd.pmf(params, t=39, x=0)

# Vectors may also be used as arguments:
bgnbd.pmf(params, t=30, x=11:20)
}
\references{
Fader, Peter S.; Hardie, Bruce G.S.and Lee, Ka Lok. “Computing
P(alive) Using the BG/NBD Model.” December. 2008.
\href{http://www.brucehardie.com/notes/021/palive_for_BGNBD.pdf}{Web.}
}
