% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pnbd.R
\name{pnbd.PlotRecVsConditionalExpectedFrequency}
\alias{pnbd.PlotRecVsConditionalExpectedFrequency}
\title{Pareto/NBD Plot Actual vs. Conditional Expected Frequency by Recency}
\usage{
pnbd.PlotRecVsConditionalExpectedFrequency(
  params,
  cal.cbs,
  T.star,
  x.star,
  hardie,
  xlab = "Calibration period recency",
  ylab = "Holdout period transactions",
  xticklab = NULL,
  title = "Actual vs. Conditional Expected Transactions by Recency"
)
}
\arguments{
\item{params}{Pareto/NBD parameters - a vector with r, alpha, s, and beta, in
that order. r and alpha are unobserved parameters for the NBD transaction
process. s and beta are unobserved parameters for the Pareto (exponential
gamma) dropout process.}

\item{cal.cbs}{calibration period CBS (customer by sufficient statistic). It
must contain columns for frequency ("x"), recency ("t.x"), and total time
observed ("T.cal"). Note that recency must be the time between the start of
the calibration period and the customer's last transaction, not the time
between the customer's last transaction and the end of the calibration
period.}

\item{T.star}{length of the holdout period. It must be a scalar for this
plot's purposes: you have one holdout period of a given length.}

\item{x.star}{vector of transactions made by each customer in the holdout
period.}

\item{hardie}{if TRUE, have
\code{\link{pnbd.ConditionalExpectedTransactions}} use \code{\link{h2f1}}
instead of \code{\link[hypergeo]{hypergeo}}.}

\item{xlab}{descriptive label for the x axis.}

\item{ylab}{descriptive label for the y axis.}

\item{xticklab}{vector containing a label for each tick mark on the x axis.}

\item{title}{title placed on the top-center of the plot.}
}
\value{
Matrix comparing actual and conditional expected transactions in the holdout period.
}
\description{
Plots the actual and conditional expected number of transactions made by
customers in the holdout period, binned according to calibration period
recencies. Also returns a matrix with this comparison and the number of
customers in each bin.
}
\details{
This function does bin customers exactly according to recency; it bins
customers according to integer units of the time period of cal.cbs.
Therefore, if you are using weeks in your data, customers will be binned as
follows: customers with recencies between the start of the calibration period
(inclusive) and the end of week one (exclusive); customers with recencies
between the end of week one (inclusive) and the end of week two (exlusive);
etc.

The matrix and plot will contain the actual number of transactions made by
each bin in the holdout period, as well as the expected number of
transactions made by that bin in the holdout period, conditional on that
bin's behavior during the calibration period.
}
\examples{
data(cdnowSummary)

cal.cbs <- cdnowSummary$cbs
# cal.cbs already has column names required by method

# number of transactions by each customer in the 39 weeks following
# the calibration period
x.star <- cal.cbs[,"x.star"]

# parameters estimated using pnbd.EstimateParameters
est.params <- cdnowSummary$est.params

# plot conditional expected holdout period transactions, binned according to
# calibration period recencies
pnbd.PlotRecVsConditionalExpectedFrequency(params = est.params, 
                                           cal.cbs = cal.cbs, 
                                           T.star = 39, 
                                           x.star = x.star, 
                                           hardie = TRUE)
}
