% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbg-cnbd-k.R
\name{mbgcnbd.GenerateData}
\alias{bgcnbd.GenerateData}
\alias{mbgcnbd.GenerateData}
\title{Simulate data according to (M)BG/CNBD-k model assumptions}
\usage{
mbgcnbd.GenerateData(n, T.cal, T.star = NULL, params,
  date.zero = "2000-01-01")

bgcnbd.GenerateData(n, T.cal, T.star = NULL, params,
  date.zero = "2000-01-01")
}
\arguments{
\item{n}{Number of customers.}

\item{T.cal}{Length of calibration period. If a vector is provided, then it
is assumed that customers have different 'birth' dates, i.e.
\eqn{max(T.cal)-T.cal}.}

\item{T.star}{Length of holdout period. This may be a vector.}

\item{params}{A vector with model parameters \code{k}, \code{r},
\code{alpha}, \code{a} and \code{b}, in that order.}

\item{date.zero}{Initial date for cohort start. Can be of class character, Date or POSIXt.}
}
\value{
List of length 2:
\item{\code{cbs}}{A data.frame with a row for each customer and the summary statistic as columns.}
\item{\code{elog}}{A data.frame with a row for each transaction, and columns \code{cust}, \code{date} and \code{t}.}
}
\description{
Simulate data according to (M)BG/CNBD-k model assumptions
}
\examples{
params <- c(k = 3, r = 0.85, alpha = 1.45, a = 0.79, b = 2.42)
data <- mbgcnbd.GenerateData(n = 1000, T.cal = 24, T.star = 32, params)

# customer by sufficient summary statistic - one row per customer
head(data$cbs)

# event log - one row per event/transaction
head(data$elog)
}
\references{
Platzer Michael, and Thomas Reutterer (submitted)
}

