% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.R
\name{mcmc.plotPActiveDiagnostic}
\alias{mcmc.plotPActiveDiagnostic}
\title{Draw diagnostic plot to inspect error in P(active).}
\usage{
mcmc.plotPActiveDiagnostic(cbs, xstar,
  title = "Diagnostic Plot for P(active)")
}
\arguments{
\item{cbs}{A data.frame with column \code{x} and \code{x.star}.}

\item{xstar}{Future transaction draws as returned by
\code{\link{mcmc.DrawFutureTransactions}}.}

\item{title}{Plot title.}
}
\description{
Draw diagnostic plot to inspect error in P(active).
}
\examples{
data("groceryElog")
cbs <- elog2cbs(groceryElog, T.cal = "2006-12-31")
param.draws <- pnbd.mcmc.DrawParameters(cbs,
  mcmc = 200, burnin = 100, thin = 20, chains = 1) # short MCMC to run demo fast
xstar.draws <- mcmc.DrawFutureTransactions(cbs, param.draws)
mcmc.plotPActiveDiagnostic(cbs, xstar.draws)
}

