% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbd.R
\name{nbd.EstimateParameters}
\alias{nbd.EstimateParameters}
\title{Parameter Estimation for the NBD model}
\usage{
nbd.EstimateParameters(cal.cbs, par.start = c(1, 1),
  max.param.value = 10000)
}
\arguments{
\item{cal.cbs}{Calibration period CBS. It must contain columns for frequency
\code{x} and total time observed \code{T.cal}.}

\item{par.start}{Initial NBD parameters - a vector with \code{r} and \code{alpha} in
that order.}

\item{max.param.value}{Upper bound on parameters.}
}
\value{
List of estimated parameters.
}
\description{
Estimates parameters for the NBD model via Maximum Likelihood Estimation.
}
\examples{
data("groceryElog")
cbs <- elog2cbs(groceryElog)
nbd.EstimateParameters(cbs)
}
\references{
EHRENBERG, ASC. 'The Pattern of Consumer Purchases.' Quantitative
  techniques in marketing analysis: text and readings (1962): 355.
}

