% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbd.R
\name{nbd.GenerateData}
\alias{nbd.GenerateData}
\title{Simulate data according to NBD model assumptions}
\usage{
nbd.GenerateData(n, T.cal, T.star, params, date.zero = "2000-01-01")
}
\arguments{
\item{n}{Number of customers.}

\item{T.cal}{Length of calibration period.}

\item{T.star}{Length of holdout period. This may be a vector.}

\item{params}{NBD parameters - a vector with \code{r} and \code{alpha} in that order.}

\item{date.zero}{Initial date for cohort start. Can be of class character, Date or POSIXt.}
}
\value{
List of length 2:
\item{\code{cbs}}{A data.frame with a row for each customer and the summary statistic as columns.}
\item{\code{elog}}{A data.frame with a row for each transaction, and columns \code{cust}, \code{date} and \code{t}.}
}
\description{
Simulate data according to NBD model assumptions
}
\examples{
n <- 200  # no. of customers
T.cal <- 32  # length of calibration period
T.star <- 32  # length of hold-out period
params <- c(r = 0.85, alpha = 4.45)  # purchase frequency lambda_i ~ Gamma(r, alpha)
data <- nbd.GenerateData(n, T.cal, T.star, params)
cbs <- data$cbs  # customer by sufficient summary statistic - one row per customer
elog <- data$elog  # Event log - one row per event/purchase
}
