% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BTtest.R
\name{BaiIPC}
\alias{BaiIPC}
\title{Bai (2004) IPC}
\usage{
BaiIPC(X, r_max = 10)
}
\arguments{
\item{X}{a \eqn{T \times N} numerical \code{matrix} or \code{data.frame} of observations.}

\item{r_max}{the maximum number of factors to consider. Default is 10.}
}
\value{
A vector of the estimated number of factors for each of the three criteria.
}
\description{
Calculates the Integrated Panel Criteria (\emph{IPC}) to estimate the total number of common trends in a nonstationary panel as proposed by Bai (2004).
}
\details{
For further details on the three criteria and their respective differences, I refer to Bai (2004, sec. 3).
}
\examples{
# Simulate a nonstationary panel
X <- sim_DGP(N = 100, n_Periods = 200)

# Obtain the estimated number of common factors pre criterion
BaiIPC(X = X, r_max = 10)
}
\references{
Bai, J. (2004). Estimating cross-section common stochastic trends in nonstationary panel data. \emph{Journal of Econometrics}, 122(1), 137-183. \doi{10.1016/j.jeconom.2003.10.022}
}
\author{
Paul Haimerl
}
