% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/97_companion.R
\name{companion.bvar}
\alias{companion.bvar}
\alias{companion}
\title{Retrieve companion matrix from a Bayesian VAR}
\usage{
\method{companion}{bvar}(object, conf_bands = 0.5, complete = FALSE, ...)

companion(object, ...)
}
\arguments{
\item{object}{A \code{bvar} object, obtained from \code{\link{bvar}}.}

\item{conf_bands}{Numeric vector of desired confidence bands to apply.
E.g. for bands at 5\%, 10\%, 90\% and 95\% set this to \code{c(0.05, 0.1)}.
Note that the median, i.e. \code{0.5} is always included.}

\item{complete}{Logical value. Whether to retrieve the companion matrix for
all saved draws of the VAR coefficients. Overrides \code{conf_bands} if set
\code{TRUE}.}

\item{...}{Not used.}
}
\value{
Returns a numeric array/matrix of class \code{bvar_comp} with the
VAR's coefficents in companion form, at the specified confidence bands.
}
\description{
Calculates the companion matrix for Bayesian VARs generated via
\code{\link{bvar}}.
}
\examples{
\donttest{
data <- matrix(rnorm(200), ncol = 2)
x <- bvar(data, lags = 2)

# Get companion matrices for confidence bands at to 10\%, 50\% and 90\%
companion(x, conf_bands = 0.10, complete = FALSE)

# Get companion matrices for all draws of the VAR coefficients
companion(x, complete = TRUE)
}
}
\seealso{
\code{\link{bvar}}; \code{\link{coef}}
}
