% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{bwgs.predict}
\alias{bwgs.predict}
\title{Computes the GEBV prediction for the target population with only genotypic Data using the options for model selection.}
\usage{
bwgs.predict(
  geno_train,
  pheno_train,
  geno_target,
  FIXED_train = "NULL",
  FIXED_target = "NULL",
  MAXNA = 0.2,
  MAF = 0.05,
  geno.reduct.method = "NULL",
  reduct.size = "NULL",
  r2 = "NULL",
  pval = "NULL",
  MAP = "NULL",
  geno.impute.method = "NULL",
  predict.method = "GBLUP"
)
}
\arguments{
\item{geno_train}{Matrix (n x m) of genotypes for the training population: n lines with m markers. Genotypes should be coded as {-1, 0, 1, NA}. Missing data are allowed and coded as NA.}

\item{pheno_train}{Vector (n x 1) of phenotype for the training phenotypes. This vector should have no missing values. Otherwise, missing values (NA) will be omitted in both pheno_train and geno_train.}

\item{geno_target}{Matrix (z x m) of genotypes for the target population: z lines with the same m markers as in geno_train. Genotypes should be coded as {-1, 0, 1, NA}. Missing data are allowed and coded as NA. Other arguments are identical to those of bwgs.cv, except pop_reduct_method, nTimes and nFolds, since the prediction is run only once, using the whole training population for model estimation, then applied to the target population.}

\item{FIXED_train}{A matrix of fixed effect for training, to be used with some methods such as those included in BGLR, MUST have same rownames as geno and coded(-1 0 1)}

\item{FIXED_target}{A matrix of fixed effect for targeting, to be used with some methods such as those included in BGLR, MUST have same rownames as geno and coded(-1 0 1)}

\item{MAXNA}{The maximum proportion of missing value which is admitted for filtering marker columns in geno. Default value is 0.2}

\item{MAF}{The minimum allele frequency for filtering marker colums in geno; default value is 0.05}

\item{geno.reduct.method}{Allows sampling a subset of markers for speeding up computing time and/or avoid introducing more noise than informative markers. Options are:
\itemize{
    \item{RMR: Random sampling (without replacement) of a subset of markers. To be used with the parameter “reduct.marker.size”.}
    \item{LD (with r2 and MAP): enables “pruning” of markers which are in LD > r2. Only the marker with the least missing values is kept for each pair in LD>r2. To allow faster computation, r2 is estimated chromosome by chromosome, so a MAP file is required with information of marker assignation to chromosomes. The MAP file should contain at least three columns: marker_name, chromosome_name and distance_from_origin (either genetic of physical distance, only used for sorting markers, LD being re-estimated from marker Data).}
    \item{ANO (with pval): one-way ANOVA are carried out with R function lm on trait “pheno”. Every markers are tested one at a time, and only markers with pvalue<pval are kept for GEBV prediction.}
    \item{ANO+LD (with pval and r2, MAP is facultative): combines a first step of marker selection with ANO, then a second step of pruning using LD option.}
}}

\item{reduct.size}{Specifies the number of markers for the genotypic reduction using RMR (reduct.size < m).}

\item{r2}{Coefficient of linkage disequilibrium (LD). Setting 0<r2<1 if the genotypic reduction method is in {LD or ANO+LD }.}

\item{pval}{p value for ANO method, 0 < pval < 1.}

\item{MAP}{A file with markers in rows ane at least ONE columns with colnames= "chrom". Used for computing r2 within linkage groups.}

\item{geno.impute.method}{Allow missing marker data imputation using the two methods proposed in function A.mat of package rrBLUP, namely:
\itemize{
    \item{MNI: missing data are replaced by the mean allele frequency of the marker (column in geno)}
    \item{EMI: missing data are replaced using an expectation-maximization methods described in function A.mat (Endelman & Janninck 2012).}
}

Default value is NULL.

Note that these imputation methods are only suited when there are a few missing value, typically in marker data from SNP chips of KasPAR. They are NOT suited for imputing marker data from low density to high density designs, and when there are MANY missing Data as typically provided by GBS. More sophisticated software (e.g. Beagles, Browning & Browning 2016) should be used before BWGS.}

\item{predict.method}{The options for genomic breeding value prediction methods. The available options are:
\itemize{
   \item{GBLUP: performs G-BLUP using a marker-based relationship matrix, implemented through BGLR R-library. Equivalent to ridge regression (RR-BLUP) of marker effects.}
   \item{EGBLUP: performs EG-BLUP, i.e. BLUP using a "squared" relationship matrix to model epistatic 2x2 interactions, as described by Jiang & Reif (2015), using BGLR library}
   \item{RR: ridge regression, using package glmnet. In theory, strictly equivalent to gblup.}
   \item{LASSO: Least Absolute Shrinkage and Selection Operator is another penalized regression methods which yield more shrinked estimates than RR. Run by glmnet library.}
   \item{EN: Elastic Net (Zou and  Hastie, 2005), which is a weighted combination of RR and LASSO, using glmnet library}
 }
 Several Bayesian methods, using the BGLR library:
 \itemize{
     \item{BRR: Bayesian ridge regression: same as rr-blup, but bayesian resolution. Induces homogeneous shrinkage of all markers effects towards zero with Gaussian distribution (de los Campos et al, 2013)}
     \item{BL: Bayesian LASSO: uses an exponential prior on marker variances priors, leading to double exponential distribution of marker effects (Park & Casella 2008)}
     \item{BA: Bayes A uses a scaled-t prior distribution of marker effects. (Meuwissen et al 2001).}
     \item{BB: Bayes B, uses a mixture of distribution with a point mass at zero and with a slab of non-zero marker effects with a scaled-t distribution (Habier et al 2011).}
     \item{BC: Bayes C same as Bayes B with a slab with Gaussian distribution.}
}
A more detailed description of these methods can be found in Perez & de los Campos 2014 (http://genomics.cimmyt.org/BGLR-extdoc.pdf).
Three semi-parametric methods:
\itemize{
    \item{RKHS: reproductive kernel Hilbert space and multiple kernel MRKHS, using BGLR (Gianola and van Kaam 2008).  Based on genetic distance and a kernel function to regulate the distribution of marker effects. This methods is claimed to be effective for detecting non additive effects.}
    \item{RF: Random forest regression, using randomForest library (Breiman, 2001, Breiman and  Cutler 2013). This methods uses regression models on tree nodes which are rooted in bootstrapping data. Supposed to be able to capture interactions between markers}
    \item{SVM: support vector machine, run by e1071 library. For details, see Chang, Chih-Chung and Lin, Chih-Jen: LIBSVM: a library for Support Vector Machines http://www.csie.ntu.edu.tw/~cjlin/libsvm}
    \item{BRNN: Bayesian Regularization for feed-forward Neural Network, with the R-package BRNN (Gianola et al 2011). To  keep computing time in reasonable limits, the parameters for the brnn function are neurons=2 and epochs = 20.}
}}
}
\value{
The object bwgs.predict returns Matrix of dimension nx3. Columns are:
\itemize{
    \item{Predict BV: the nx1 vector of GEBVs for the validation set (rows of geno_valid)}
    \item{gpredSD: Standart deviation of estimated GEBV}
    \item{CD: coefficient of determination for each GEBV, estimated as sqrt ((1-stdev(GEBVi))^2/2g)}
}
Note that gpredSD and CD are only available for methods using the BGLR library, namely GBLUP, EGBLUP, BA,BB,BC,BL,RKHS and MKRKHS. 
These two columns contain NA for methods RF, RR, LASSO, EN and SVM.
}
\description{
Computes the GEBV prediction for the target population with only genotypic Data using the options for model selection.
}
\examples{
\donttest{
data(inra)
# Prediction using GBLUP method
predict_gblup <- bwgs.predict(geno_train = TRAIN47K,
     pheno_train = YieldBLUE,
     geno_target = TARGET47K,
     MAXNA = 0.2, 
     MAF = 0.05,
     geno.reduct.method = "NULL",
     reduct.size = "NULL",
     r2 = "NULL",
     pval = "NULL",
     MAP = "NULL",
     geno.impute.method = "MNI",
     predict.method = "GBLUP")
}
}
