% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{read_nmrstar_file}
\alias{read_nmrstar_file}
\title{Extracts data from BMRB STAR 3.0 file.
\code{read_nmrstar_file()} parses BMRB STAR 3.0 file. It will extract sequence information and chemical shifts for both alpha and beta carbons.}
\usage{
read_nmrstar_file(file_path)
}
\arguments{
\item{file_path}{File path where input chemical shifts file is located}
}
\value{
Protein sequence and chemical shifts dataframe.
}
\description{
Extracts data from BMRB STAR 3.0 file.
\code{read_nmrstar_file()} parses BMRB STAR 3.0 file. It will extract sequence information and chemical shifts for both alpha and beta carbons.
}
\examples{
## Download a BMRB file
library(BMRBr)
\dontrun{bmrb_download(id_list = "4020", output_dir = "./", verbose = F)}

## Read in BMRB file and procec
file_path = "bmr4020.str"
\dontrun{head(read_nmrstar_file(file_path)}

## Delete downloaded BMRB file
\dontrun{unlink("./bmr4020.str")}

}
