% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetFTSE100Stocks.R
\name{GetFTSE100Stocks}
\alias{GetFTSE100Stocks}
\title{Function to download the current components of the FTSE100 index from Wikipedia}
\usage{
GetFTSE100Stocks(do.cache = TRUE, cache.folder = "BGS_Cache")
}
\arguments{
\item{do.cache}{Use caching system? (default = TRUE)}

\item{cache.folder}{Where to save cache files? (default = 'BGS_Cache')}
}
\value{
A dataframe that includes a column with the list of tickers of companies that belong to the FTSE100 index
}
\description{
This function scrapes the stocks that constitute the FTSE100 index from the wikipedia page at <https://en.wikipedia.org/wiki/FTSE_100_Index#List_of_FTSE_100_companies>.
}
\examples{
\dontrun{
df.FTSE100 <- GetFTSE100Stocks()
print(df.FTSE100$tickers)
}
}
