% Generated by roxygen2 (4.0.1): do not edit by hand
\name{sweepRegistry}
\alias{sweepRegistry}
\title{Sweep obsolete files from the file system}
\usage{
sweepRegistry(reg, sweep = c("scripts", "conf"))
}
\arguments{
\item{reg}{[\code{\link{Registry}}]\cr
Registry.}

\item{sweep}{[\code{character}]\cr
Possible choices:
Temporary R scripts of jobs,
really not needed for anything else then execution (\dQuote{scripts}),
log file of jobs,
think about whether you later want to inspect them (\dQuote{logs}),
BatchJobs configuration files which are temporarily stored on submit,
really not needed for anything else then execution (\dQuote{conf}),
resource lists of \code{\link{submitJobs}} which are temporarily stored on submit,
think about whether you later want to inspect them (\dQuote{resources}),
Default is \code{c("scripts", "conf")}.}
}
\value{
[\code{logical}]. Invisibly returns \code{TRUE} on success and \code{FALSE}
  if some files could not be removed.
}
\description{
Removes R scripts, log files, resource informations and temporarily stored configuration files
from the registry's file directory. Assuming all your jobs completed successfully, none of these are needed
for further work. This operation potentially releases quite a lot of disk space, depending on the number of your jobs.
BUT A HUGE WORD OF WARNING:
IF you later notice something strange and need to determine the reason for it, you are at a huge disadvantage.
Only do this at your own risk and when you are sure that you have successfully completed a project and only
want to archive your produced experiments and results.
}

