\name{BPSpost2mcmc}
\alias{BPSpost2mcmc}
\title{Function to Convert BPS Posterior Samples into MCMC Objects}
\description{A function to convert a first order autoregressive BPS posterior sample into an MCMC object,
so that package 'coda' can be used for output diagnostics.}
\usage{BPSpost2mcmc(sampost)}
\arguments{
  \item{sampost}{posterior sample of BPS hazard rates (as generated by \code{\link{BPSpostSample}})}
}
\value{An MCMC object, complete with burn-in and thinning information.}
\note{If package 'coda' is not available, a matrix with meaningful column names is returned.}
\seealso{\code{\link{BayHaz-package}}, \code{\link{BPSpostSample}}}
\examples{
# set RNG seed (for example reproducibility only)
set.seed(1234)

# select a BPS prior distribution
hypars<-BPSpriorElicit(r0 = 0.1, H = 1, T00 = 50, ord = 4, G = 3, c = 0.9)
# load a data set
data(earthquakes)
# generate a posterior sample
post<-BPSpostSample(hypars, times = earthquakes$ti, obs = earthquakes$ob)

# convert the posterior sample into an MCMC object
MCMCpost<-BPSpost2mcmc(post)
}
\keyword{misc}
