\name{BPSpriorSample}
\alias{BPSpriorSample}
\title{Function to Sample Hazard Rates from BPS Priors}
\description{A function to generate a random sample of hazard rates from a
                    first order autoregrssive BPS prior distribution.}
\usage{BPSpriorSample(ss = 1, hyp = BPSpriorElicit())}
\arguments{
  \item{ss}{requested sample size}
  \item{hyp}{list of hyperparameters (as generated by \code{\link{BPSpriorElicit}})}
}
\details{A random sample of \code{ss} hazard rates is extracted from the first order autoregressive BPS prior distribution
             identified by \code{hyp}.}
\value{
A list with two components:
  \item{hyp}{list of hyperparameters identifying the BPS prior distribution
                    from which the sample was extracted (copy of the input argument)}
  \item{eta}{matrix with \code{ss} rows (and \code{length(hyp$knots)-hyp$ord} columns) containing the spline weights}
}
\seealso{\code{\link{BPSevalHR}}, \code{\link{BPSplotHR}}}
\examples{
# set RNG seed (for example reproducibility only)
set.seed(1234)

# select a BPS prior distribution
hypars<-BPSpriorElicit(r0 = 0.1, H = 1, T00 = 50, ord = 4, G = 3, c = 0.9)

# generate a sample of ten hazard rates
prior<-BPSpriorSample(ss = 10, hyp = hypars)
}
\keyword{distribution}
\keyword{survival}
\keyword{smooth}
