% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_Scatterplots.R
\name{plot_Scatterplots}
\alias{plot_Scatterplots}
\alias{ScatterSamples}
\title{Display Scatter Plot Matrix of the Bayesian Age Results}
\usage{
plot_Scatterplots(
  object,
  variables = c("A"),
  sample_names = NULL,
  sample_selection = NULL,
  n.chains = NULL,
  plot_type = "hexbin",
  plot_mode = "matrix",
  ...
)

ScatterSamples(...)
}
\arguments{
\item{object}{\link[coda:mcmc.list]{coda::mcmc.list} or a \link{data.frame} (\strong{required}): mcmc list objects generated by \link[rjags:jags.model]{rjags::jags.model} in \link{AgeS_Computation},
\link{AgeC14_Computation} or \link{Age_OSLC14}. If a \link{data.frame} is provided, only the first two columns are taken and \code{NA} values are automatically
removed.}

\item{variables}{\link{character} (\emph{with default}): variable to be selected for the scatter plot, e.g., \code{"A"}. Please note
that you can only select one variable at the time}

\item{sample_names}{\link{character} (\emph{optional}): sample names shown in the plot matrix}

\item{sample_selection}{\link{numeric} (\emph{with default}): vector of samples to be plotted in the scatter matrix, e.g.,
\code{c(1,2)} will plot the first two samples, \code{c(1,3)} will plot samples 1 and 3 and \code{c(1:3)} will plot the first
three samples}

\item{n.chains}{\link{integer} (\emph{with default}): allows to limit the number of chains shown,
by default the results of all chains are plotted.}

\item{plot_type}{\link{character} (\emph{with default}): switch between different plot types, \code{"hexbin"} (the default), based on
the function \link[hexbin:hexplom]{hexbin::hexplom} and \code{smoothScatter} (the alternative) based on a highly customised plot function using the
function \link[graphics:smoothScatter]{graphics::smoothScatter}}

\item{plot_mode}{\link{character} (\emph{with default}): switch between a \code{matrix} plot mode and a \code{single} plot mode. The plot mode \code{single}
only works for \code{plot_type = smoothScatter} and creates a single plot panel for each sample. Please note that this cannot be further
combined with other par settings.}

\item{...}{further arguments to control the plot output, standard plot arguments supported are \code{main}, \code{xlab}, \code{ylab}, \code{xlim}, \code{ylim}, \code{cex}. For additional
arguments supporting a fine tuning of the plot, see details.}
}
\value{
A scatter plot based on \link[hexbin:hexplom]{hexbin::hexplom}
}
\description{
Create a hexbin plot matrix (\link[hexbin:hexplom]{hexbin::hexplom}) of age results returned by the bayesian age calculation.
}
\details{
\strong{Addtional supported plot arguments}\cr

The following table lists additional arguments supported by the function in order to fine tune the
graphical output. Such arguments, can just be added in the function call. Example, for disabling
the \link[graphics:rug]{graphics::rug} in the plot mode \code{smoothScatter} you can type \code{plot_Scatterplots(..., rug = FALSE)}
Please note that not all arguments are supported by all plot types.

\tabular{lll}{
\strong{ARGUMENT} \tab \strong{SUPPORTED BY PLOT TYPE} \tab \strong{DESCRIPTION} \cr
\code{colramp} \tab \code{hexbin} and \code{smoothScatter} \tab Option to define an own colour ramp, by defining an own function, e.g., \code{function(n) heat.colors(n, alpha = 1)}. \cr
\code{pscales} \tab \code{hexbin} and \code{smoothScatter} \tab Controls the number of ticks shown on the plot axes, please note that the number works proportionally. \cr
\code{bw_smoothScatter} \tab \code{smoothScatter} \tab Controls the bandwith of the smooth scatter, cf. \link[graphics:smoothScatter]{graphics::smoothScatter} \cr
\code{rug} \tab \code{smoothScatter} \tab enables/disables rugs \cr
\code{nlevels} \tab \code{smoothScatter} \tab controls the number of isolines shown (cf. \link[graphics:contour]{graphics::contour}) \cr
\code{nrpoints} \tab \code{smoothScatter} \tab defines the number of \code{nrpoints} to be plotted \link[graphics:smoothScatter]{graphics::smoothScatter} \cr
\code{col_contour} \tab \code{smoothScatter} \tab defines the colour of the contour lines \cr
\code{col_nrpoints} \tab \code{smoothScatter} \tab sets colour of the nrpoints in the scatter plot

}
}
\section{Function version}{
 0.3.1
}

\examples{
data(AgeS,envir = environment())

##hexbin
plot_Scatterplots(
   object = AgeS$Sampling,
   sample_names = c("GDB5", "GDB3"),
   sample_selection = c(1,2)
 )

##scatter smooth (matrix)
plot_Scatterplots(
   object = AgeS$Sampling,
   sample_names = c("GDB5", "GDB3"),
   sample_selection = c(1,2),
   plot_type = "smoothScatter")


##scatter smooth (single)
plot_Scatterplots(
   object = AgeS$Sampling,
   sample_names = c("GDB5", "GDB3"),
   sample_selection = c(1,2),
   plot_type = "smoothScatter",
   plot_mode = "single")

}
\seealso{
\link{Age_Computation}, \link{AgeS_Computation}, \link{AgeC14_Computation},
and \link{rjags} packages.
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, UMR 5060, CNRS - Université Bordeaux Montaigne (France),
based on the function 'ScatterSamples()' by Claire Christophe, Anne Philippe, Guillaume Guérin
} 

\section{How to cite}{
Kreutzer, S., Christophe, C., Philippe, A., 2020. plot_Scatterplots(): Display Scatter Plot Matrix of the Bayesian Age Results. Function version 0.3.1. In: Christophe, C., Philippe, A., Kreutzer, S., Guerin, G., 2020. BayLum: Chronological Bayesian Models Integrating Optically Stimulated. R package version 0.2.0. https://CRAN.r-project.org/package=BayLum
}

