% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cace.meta.c.R
\name{cace.meta.c}
\alias{cace.meta.c}
\title{Bayesian hierarchical models for CACE meta-analysis with complete compliance data}
\usage{
cace.meta.c(
  data,
  param = c("CACE", "u1out", "v1out", "s1out", "b1out", "pic", "pin", "pia"),
  prior.type = "default",
  delta.n = TRUE,
  delta.a = TRUE,
  delta.u = TRUE,
  delta.v = TRUE,
  delta.s = TRUE,
  delta.b = TRUE,
  cor = TRUE,
  digits = 3,
  n.adapt = 1000,
  n.iter = 1e+05,
  n.burnin = floor(n.iter/2),
  n.chains = 3,
  n.thin = max(1, floor((n.iter - n.burnin)/1e+05)),
  conv.diag = FALSE,
  mcmc.samples = FALSE,
  study.specific = FALSE
)
}
\arguments{
\item{data}{an input dataset with the same structure as the example data `epidural_c`, 
containing multiple rows referring to multiple studies in a meta-analysis.}

\item{param}{a character string vector indicating the parameters to be tracked and estimated. 
By default the following parameters (see \code{details}) are included: \eqn{\theta^{CACE}} 
(\code{CACE}), \eqn{E(u_{i1})} (\code{u1out}), \eqn{E(v_{i1})} (\code{v1out}), \eqn{E(s_{i1})} (\code{s1out}), 
\eqn{E(b_{i1})} (\code{b1out}), \eqn{\pi_a} (\code{pia}), \eqn{\pi_n} (\code{pin}), and 
\eqn{\pi_c=1-\pi_a-\pi_n} (\code{pic}). 
Users can modify the string vector to only include parameters of interest besides \eqn{\theta^{CACE}}.}

\item{prior.type}{the default priors are used by the default assignment `prior.type="default"`.
Like the function \code{\link{cace.study}}, weakly informative priors \eqn{\alpha_n, \alpha_a \sim 
N(0, 2.5^2)} and \eqn{\alpha_s, \alpha_b, \alpha_u, \alpha_v \sim N(0, 2^2)} are assigned to the 
means of these transformed parameters:
\eqn{\pi_{in}=\frac{\exp(n_i)}{1+\exp(n_i)+\exp(a_i)}}, \eqn{\pi_{ia}=\frac{\exp(a_i)}{1+\exp(n_i)+\exp(a_i)}}, 
where \eqn{n_i=\alpha_n+\delta_{in}}, \eqn{a_i=\alpha_a+\delta_{ia}}, \eqn{logit(s_{i1})=\alpha_s + \delta_{is}},
\eqn{logit(b_{i1})=\alpha_b + \delta_{ib}}, \eqn{probit(u_{i1})=\alpha_u + \delta_{iu}}, 
and \eqn{probit(v_{i1})=\alpha_v + \delta_{iv}}. 
Alternatively, this function allows users to specify their own prior distributions by saving a separate 
`R` file \code{prior.meta.R} under the same directory with the model file, and assigning the argument 
`prior.type = "custom"`.
Users can modify the above customized file \code{prior.meta.R} to assign their preferred prior 
distributions. Note that same as the function \code{\link{cace.study}}, the function cannot
combine the default priors with partial user-defined prior distributions. Thus users need to 
be careful when choosing the customized priors: the pre-defined `R` file \code{prior.meta.R} must 
include distributions for all hyper-parameters.}

\item{delta.n}{logical values indicating whether the 
corresponding random effect is included in the model. The default model sets all of these arguments 
to `TRUE`. Note that \eqn{\rho} (\code{cor}) can only be included when both \eqn{\delta_{in}} 
(\code{delta.n}) and \eqn{\delta_{ia}} (\code{delta.a}) are set to `TRUE`. Otherwise, a warning 
occurs and the model continues running by forcing `delta.n = TRUE` and `delta.a = TRUE`.}

\item{delta.a}{see description of delta.n for more information}

\item{delta.u}{see description of delta.n for more information}

\item{delta.v}{see description of delta.n for more information}

\item{delta.s}{see description of delta.n for more information}

\item{delta.b}{see description of delta.n for more information}

\item{cor}{see description of delta.n for more information}

\item{digits}{number of digits. Default to 3.}

\item{n.adapt}{adapt value. Default to 1000.}

\item{n.iter}{number of iterations. Default to 100000.}

\item{n.burnin}{number of burn-in iterations. Default to n.iter/2.}

\item{n.chains}{number of chains. Default to 3.}

\item{n.thin}{Default to max(1,floor((n.iter-n.burnin)/100000)).}

\item{conv.diag}{Default to False.}

\item{mcmc.samples}{Default to False.}

\item{study.specific}{a logical value indicating whether to calculate the study-specific 
\eqn{\theta^{CACE}_i}. If `TRUE`, the model will first check the logical status of arguments 
\code{delta.u} and \code{delta.v}. If both are `FALSE`, meaning that neither response rate \eqn{u_{i1}} 
or \eqn{v_{i1}} is modeled with a random effect, then the study-specific \eqn{\theta^{CACE}_i} is 
the same across studies. The function gives a warning and continues by making `study.specific = FALSE`. 
Otherwise, the study-specific \eqn{\theta^{CACE}_i} are estimated and saved as the parameter \code{cacei}.}
}
\value{
It returns a model object of class "cace.Bayes"
}
\description{
This function performs the Bayesian hierarchical model method for meta-analysis 
when the dataset has complete compliance information for all studies, 
as described in the paper Section 2.2.2, the Bayesian hierarchical model.
}
\examples{
\donttest{
data("epidural_c", package = "BayesCACE")
set.seed(123)
out.meta.c <- cace.meta.c(data = epidural_c, conv.diag = TRUE, 
mcmc.samples = TRUE, study.specific = TRUE)
# By calling the object smry from the output list out.meta.c, posterior estimates 
# (posterior mean, standard deviation, posterior median, 95\\% credible interval, and 
# time-series standard error) are displayed.
out.meta.c$smry
out.meta.c$DIC
}
}
\references{
{
\insertRef{zhou2019bayesian}{BayesCACE}
\insertRef{zhou2020software}{BayesCACE}
\insertRef{lunn2012bugs}{BayesCACE}
\insertRef{zeger1988models}{BayesCACE}
}
}
\seealso{
\code{\link[BayesCACE]{cace.study}}, \code{\link[BayesCACE]{cace.meta.ic}}
}
