% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapter-stepsize.R
\name{sadapter.DualAverage}
\alias{sadapter.DualAverage}
\title{Use Dual Averaging like in STAN to tune stepsize}
\usage{
sadapter.DualAverage(
  adapt_steps,
  initial_stepsize = 1,
  target_accept = 0.65,
  gamma = 0.05,
  t0 = 10,
  kappa = 0.75
)
}
\arguments{
\item{adapt_steps}{number of adaptation steps}

\item{initial_stepsize}{initial stepsize}

\item{target_accept}{target acceptance ratio}

\item{gamma}{See STAN manual NUTS paper}

\item{t0}{See STAN manual or NUTS paper}

\item{kappa}{See STAN manual or NUTS paper}
}
\value{
list with `juliavar`, `juliacode`, and all given arguments
}
\description{
Use Dual Averaging like in STAN to tune stepsize
}
\examples{
\dontrun{
  ## Needs previous call to `BayesFluxR_setup` which is time
  ## consuming and requires Julia and BayesFlux.jl
  BayesFluxR_setup(installJulia=TRUE, seed=123)
  net <- Chain(Dense(5, 1))
  like <- likelihood.feedforward_normal(net, Gamma(2.0, 0.5))
  prior <- prior.gaussian(net, 0.5)
  init <- initialise.allsame(Normal(0, 0.5), like, prior)
  x <- matrix(rnorm(5*100), nrow = 5)
  y <- rnorm(100)
  bnn <- BNN(x, y, like, prior, init)
  sadapter <- sadapter.DualAverage(100)
  sampler <- sampler.GGMC(sadapter = sadapter)
  ch <- mcmc(bnn, 10, 1000, sampler)
}

}
