DS.macro.inf <-
function(DS.GF.obj, num.modes =1 , iters = 500, 
						 method = c("mean","mode")){

# INPUTS
#  DS.GF.obj		AutoBayes-DataCorrect object
#  num.modes		For mode inference: number of modes expected
#  method			mean finds the bootstrap mean and sd (parameteric)
#					mode finds the bootstrap mode and sd (DS)
# OUTPUTS
#  model.modes		modes of the DC prior generated by object
#  mode.sd			standard deviation of modes (generated through simulation)
#  prior.data		dataframe of prior information for plotting
#  boot.modes/means	bootstrap mode or mean for simulation
	#require(bbmle)
	method = match.arg(method)
	test.distname <- "betabinom.ab"
			test.ddistname <- paste("d", test.distname, sep = "")
			fnobj.test <- function(par, x, n, test.ddistnam) {
									-sum(do.call(test.ddistnam, c(list(x), list(n), par, log = TRUE)))
				}
	switch(method,
		"mode" = {
			out <- list()				 
			modes.mat <- matrix(0, nrow = iters, ncol = num.modes)
			if(sum(DS.GF.obj$LP.par^2) == 0){
				m.new = 0
				out$model.modes <- Local.Mode(DS.GF.obj$prior.data$theta.vals, DS.GF.obj$prior.data$parm.prior)
				} else {
				m.new = length(DS.GF.obj$LP.par)
				out$model.modes <- Local.Mode(DS.GF.obj$prior.data$theta.vals, DS.GF.obj$prior.data$ds.prior)
				}
			for(i in 1:iters){
			len.mode = num.modes+1
			while(len.mode != num.modes){
				par.g <- c(NA,NA)
				while(!is.finite(par.g[1])==TRUE | !is.finite(par.g[2])==TRUE){
					log.lik.test <- NA
					while(!is.finite(log.lik.test)==TRUE){
						samps <- rDS(k = dim(DS.GF.obj$obs.data)[1], DS.GF.obj$g.par, DS.GF.obj$LP.par)  
						y.new<-NULL
						for(j in 1:dim(DS.GF.obj$obs.data)[1]){
							y.new[j] <- rbinom(1, DS.GF.obj$obs.data$n[j], samps[j])
							}
						new.df<- data.frame(y = y.new, n = DS.GF.obj$obs.data$n)
						test.start <- mom.est(new.df$y, new.df$n)
						log.lik.test <- fnobj.test(test.start, new.df$y, new.df$n, test.ddistname)
						}
					par.g <- BetaBinoMLE(new.df$y, new.df$n)$estimate
					}			
				new.LPc <- DS.prior(new.df, max.m = m.new, 
							    start.par = par.g)
				if(sum(new.LPc$LP.par^2) == 0){
					modes.new <- Local.Mode(new.LPc$prior.data$theta.vals, new.LPc$prior.data$parm.prior)
					} else {
					modes.new <- Local.Mode(new.LPc$prior.data$theta.vals, new.LPc$prior.data$ds.prior)
					}
				len.mode <- length(modes.new)
				}
		modes.mat[i,] <- modes.new
		}
		out$boot.modes <- colMeans(modes.mat)
		out$mode.sd <- apply(modes.mat,2,sd)
		out$prior.data <- DS.GF.obj$prior.data
		class(out) <- "DS_GF_macro_mode"
		return(out)	
		},
		"mean" = {
			out <- list()
			par.mean.vec <- NULL
			#ds.mean.vec <- NULL
			for(i in 1:iters){
				par.g <- c(NA,NA)
				while(!is.finite(par.g[1])==TRUE | !is.finite(par.g[2])==TRUE){
					log.lik.test <- NA
					while(!is.finite(log.lik.test)==TRUE){
						#DS.GF.obj <- terb.ds
						samps <- rDS(k = dim(DS.GF.obj$obs.data)[1], DS.GF.obj$g.par, DS.GF.obj$LP.par)  
						y.new<-NULL
						for(j in 1:dim(DS.GF.obj$obs.data)[1]){
							y.new[j] <- rbinom(1, DS.GF.obj$obs.data$n[j], samps[j])
							}
						new.df<- data.frame(y = y.new, n = DS.GF.obj$obs.data$n)
						test.start <- mom.est(new.df$y, new.df$n)
						log.lik.test <- fnobj.test(test.start, new.df$y, new.df$n, test.ddistname)
						log.lik.test
						}
					par.g <- BetaBinoMLE(new.df$y, new.df$n)$estimate
					par.g
					}				
				par.mean.vec[i] <- par.g[1]/(par.g[1]+par.g[2])
				}
			out$model.mean <- DS.GF.obj$g.par[1]/(DS.GF.obj$g.par[1]+DS.GF.obj$g.par[2])
			out$boot.mean <- mean(par.mean.vec)
			out$mean.sd <- sd(par.mean.vec)
			out$prior.data <- DS.GF.obj$prior.data
			class(out) <- "DS_GF_macro_mean"
			return(out)
		}	
		)
}
