% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_top_k.R
\name{predict_top_k}
\alias{predict_top_k}
\title{Predict Top-k Rankings with Pairwise Preferences}
\usage{
predict_top_k(model_fit, burnin, k, n_samples)
}
\arguments{
\item{model_fit}{An object of type \code{BayesMallows}, returned from
\code{\link{compute_mallows}}.}

\item{burnin}{A numeric value specifying the number of iterations
to discard as burn-in. See \code{\link{assess_convergence}}.}

\item{k}{Integer specifying the k in top-\eqn{k}.}

\item{n_samples}{The number of samples, after burn-in.}
}
\description{
Predict the posterior probability, per item, of being ranked among the top-\eqn{k}
for each assessor. This is useful when the data take the form of pairwise
preferences. This is an internal function used by \code{\link{plot_top_k}}.
}
\seealso{
\code{\link{plot_top_k}}
}
\keyword{internal}
