% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.SMCMallows.R, R/smc_mallows_deprecated.R
\name{plot.SMCMallows}
\alias{plot.SMCMallows}
\alias{plot_alpha_posterior}
\alias{plot_rho_posterior}
\title{Plot SMC Posterior Distributions}
\usage{
\method{plot}{SMCMallows}(
  x,
  nmc = nrow(x$rho_samples[, 1, ]),
  burnin = 0,
  parameter = "alpha",
  time = ncol(x$rho_samples[, 1, ]),
  C = 1,
  colnames = NULL,
  items = NULL,
  ...
)

plot_alpha_posterior(output, nmc, burnin)

plot_rho_posterior(output, nmc, burnin, C, colnames = NULL, items = NULL)
}
\arguments{
\item{x}{An object of type \code{SMC-Mallows}, returned for example from
\code{\link{smc_mallows_new_users}}.}

\item{nmc}{Number of Monte Carlo samples}

\item{burnin}{A numeric value specifying the number of iterations
to discard as burn-in. Defaults to \code{model_fit$burnin}, and must be
provided if \code{model_fit$burnin} does not exist. See
\code{\link{assess_convergence}}.}

\item{parameter}{Character string defining the parameter to plot. Available
options are \code{"alpha"} and \code{"rho"}.}

\item{time}{Integer determining the update slice to plot}

\item{C}{Number of cluster}

\item{colnames}{A vector of item names. If NULL, generic names are generated
for the items in the ranking.}

\item{items}{Either a vector of item names, or a vector of indices. If NULL,
five items are selected randomly.}

\item{...}{Other arguments passed to \code{\link[base]{plot}} (not used).}
}
\value{
A plot of the posterior distributions
}
\description{
Plot posterior distributions of SMC-Mallow parameters.
}
\section{Functions}{
\itemize{
\item \code{plot_alpha_posterior()}: Deprecated function for
\code{plot_alpha_posterior}.

\item \code{plot_rho_posterior()}: Deprecated function for
\code{plot_rho_posterior}.

}}
\examples{
set.seed(994)

n_items <- dim(sushi_rankings)[2]
metric <- "footrule"

# Estimate the logarithm of the partition function of the Mallows rank model
logz_estimate <- estimate_partition_function(
  method = "importance_sampling",
  alpha_vector = seq(from = 0, to = 15, by = 0.5), n_items = n_items,
  metric = metric, nmc = 1e2, degree = 10
)

# Perform the resample-move SMC algorithm
smc_test <- smc_mallows_new_users(
  R_obs = sushi_rankings[1:100, ], type = "complete", n_items = n_items,
  metric = metric, leap_size = floor(n_items / 5), N = 100, Time = 10,
  logz_estimate = logz_estimate, mcmc_kernel_app = 5, num_new_obs = 5,
  alpha_prop_sd = 0.5, lambda = 0.15, alpha_max = 1e3
)

# Plot rho
plot(smc_test, colnames = colnames(sushi_rankings), parameter = "rho")

# Plot alpha
plot(smc_test, parameter = "alpha")
}
\author{
Waldir Leoncio
}
\keyword{internal}
