% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_progress_report.R
\name{set_progress_report}
\alias{set_progress_report}
\title{Set progress report options for MCMC algorithm}
\usage{
set_progress_report(verbose = FALSE, report_interval = 1000)
}
\arguments{
\item{verbose}{Boolean specifying whether to report progress or not. Defaults
to \code{FALSE}.}

\item{report_interval}{Strictly positive number specifying how many
iterations of MCMC should be run between each progress report. Defaults to
\code{1000}.}
}
\value{
An object of class \code{"BayesMallowsProgressReport"}, to be provided in
the \code{progress_report} argument to \code{\link[=compute_mallows]{compute_mallows()}} and
\code{\link[=compute_mallows_mixtures]{compute_mallows_mixtures()}}.
}
\description{
Specify whether progress should be reported, and how often.
}
\references{
\insertAllCited{}
}
\seealso{
Other preprocessing: 
\code{\link{get_transitive_closure}()},
\code{\link{set_compute_options}()},
\code{\link{set_initial_values}()},
\code{\link{set_model_options}()},
\code{\link{set_priors}()},
\code{\link{set_smc_options}()},
\code{\link{setup_rank_data}()}
}
\concept{preprocessing}
