% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SGV.R
\name{calculateU_ns}
\alias{calculateU_ns}
\title{Calculate the (sparse) matrix U}
\usage{
calculateU_ns(dist1_3d, dist2_3d, dist12_3d, Sigma11, Sigma22, Sigma12,
  log_sigma_vec, log_tau_vec, nu, nID, cond_on_y, N, k, d, M = 0)
}
\arguments{
\item{dist1_3d}{N x (k+1) x (k+1) array of distances in the x-coordinate 
direction.}

\item{dist2_3d}{N x (k+1) x (k+1) array of distances in the y-coordinate 
direction.}

\item{dist12_3d}{N x (k+1) x (k+1) array of cross-distances.}

\item{Sigma11}{N-vector; 1-1 element of the Sigma() process.}

\item{Sigma22}{N-vector; 2-2 element of the Sigma() process.}

\item{Sigma12}{N-vector; 1-2 element of the Sigma() process.}

\item{log_sigma_vec}{N-vector; process standard deviation values.}

\item{log_tau_vec}{N-vector; nugget standard deviation values.}

\item{nu}{Scalar; Matern smoothness parameter.}

\item{nID}{N x k matrix of (ordered) neighbor indices.}

\item{cond_on_y}{A matrix indicating whether the conditioning set for each 
(ordered) location is on the latent process (y, \code{1}) or the observed 
values (z, \code{0}). Calculated in \code{sgvSetup}.}

\item{N}{Scalar; number of data measurements.}

\item{k}{Scalar; number of nearest neighbors.}

\item{d}{Scalar; dimension of the spatial domain.}

\item{M}{Scalar; number of prediction sites.}
}
\value{
Returns a sparse matrix representation of the Cholesky of the
precision matrix for a fixed set of covariance parameters.
}
\description{
\code{calculateU_ns} calculates the (sparse) matrix U (i.e., the Cholesky 
of the inverse covariance matrix) using a nonstationary covariance function.
The output only contains non-zero values and is stored as three vectors: 
(1) the row indices, (2) the column indices, and (3) the non-zero values.
NOTE: this code assumes the all inputs correspond to the ORDERED locations.
}
