% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D3_Propagate.R
\name{Propagate}
\alias{Propagate}
\title{Propagate the cluster tree}
\usage{
Propagate(tree, targets = NA)
}
\arguments{
\item{tree}{an initialized \code{\linkS4class{ClusterTree}} object}

\item{targets}{the cluster involved in evidence propagation, usually set by default}
}
\value{
a \code{\linkS4class{ClusterTree}} object
}
\description{
This function propagates the discrete compartment of a \code{\linkS4class{ClusterTree}} object.
}
\details{
The discrete compartment must be propagted to get the joint distributions
of discrete variables in each discrete clusters. A \code{\linkS4class{ClusterTree}} object must be propagated
before absorbing evidence and making queries.
}
\examples{

data(liver)
tree.init <- Initializer(dag=liver$dag, data=liver$data,
                         node.class=liver$node.class,
                         propagate = FALSE)
tree.init@propagated
tree.init.p <- Propagate(tree.init)
tree.init.p@propagated

}
\references{
Cowell, R. G. (2005). Local propagation in conditional Gaussian Bayesian networks.
Journal of Machine Learning Research, 6(Sep), 1517-1550. \cr
\cr
Lauritzen, S. L., & Spiegelhalter, D. J. (1988). Local computations with probabilities on
graphical structures and their application to expert systems. Journal of the Royal Statistical
Society. Series B (Methodological), 157-224. \cr
\cr
Yu H, Moharil J, Blair RH (2020). BayesNetBP: An R Package for Probabilistic Reasoning in Bayesian
Networks. Journal of Statistical Software, 94(3), 1-31. <doi:10.18637/jss.v094.i03>.
}
