% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datagen.R
\name{generate_dataset}
\alias{generate_dataset}
\title{Generate a toy dataset in the right format for testing BayesLinRegDTR.model.fit}
\usage{
generate_dataset(n, num_stages, p_list, num_treats)
}
\arguments{
\item{n}{Number of samples/individuals to generate}

\item{num_stages}{Total number of stages per individual}

\item{p_list}{Vector of dimension for each stage}

\item{num_treats}{Vector of number of treatment options at each stage}
}
\value{
Observed data organised as a list of \eqn{\{y, X_1, X_2..., X_{num\_stages}, A\}} where y is a
vector of the final outcomes, \eqn{X_1, X_2..., X_{num\_stages}} is a list of matrices
of the intermediate covariates and A is an \eqn{n \times num\_stages}{n x num_stages} matrix of the
assigned treatments
}
\description{
Generates a toy dataset simulating observed data of treatments over time with
final outcomes and intermediate covariates. Follows the method outlined in
\href{https://github.com/jlimrasc/BayesRegDTR/blob/main/inst/doc/Toy_Datagen.pdf}{Toy-Datagen on Github}
}
\examples{
# -----------------------------
# Initialise Inputs
# -----------------------------
n           <- 5000
num_stages  <- 3
p_list_uvt  <- rep(1, num_stages)
p_list_mvt  <- c(1, 3, 3)
num_treats  <- rep(3, num_stages)

# -----------------------------
# Main
# -----------------------------
Data_uvt    <- generate_dataset(n, num_stages, p_list_uvt, num_treats)
Data_mvt    <- generate_dataset(n, num_stages, p_list_mvt, num_treats)
}
