# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Returns the approximate restricted posterior mean survival for the PLLH model.
#'
#' Uses a grid and parameter values to approximate the restricted posterior mean survival for the PLLH model using the integral of the survival function.
#' @param Y Sequence from 0.01 to the maximum observed event time used to compute the approximate restricted mean survival time. Smaller spaced sequences results in better approximation but longer computation time.
#' @param s Vector of split points. The first and last entries must be 0 and max(Y).
#' @param lam Vector of log-hazard values at each split point location. Must be same length as s.
#' @param J Number of split points. 
#' @return Returns the approximate restricted posterior mean survival time for the PLLH model.
#' @importFrom Rcpp evalCpp
#' @useDynLib BayesReversePLLH
#' @examples
#' ##Generate Data
#' Y1=rweibull(100,4,1)
#' ##Create sequence from (0,max(Y1)) for approximation
#' Y=seq(.01,max(Y1),.01)
#' ##Parameters used to approximate the mean
#' s=c(0,1,max(Y1))
#' lam=c(-2,0,-2)
#' J=1
#' ApproxMean( Y, s, lam, J)
#' @export
ApproxMean <- function(Y, s, lam, J) {
    .Call('_BayesReversePLLH_ApproxMean', PACKAGE = 'BayesReversePLLH', Y, s, lam, J)
}

SurvPLLH <- function(Y, s, lam, J) {
    .Call('_BayesReversePLLH_SurvPLLH', PACKAGE = 'BayesReversePLLH', Y, s, lam, J)
}

#' Samples from the PEH Cox model with a treatment indicator.
#'
#' Samples from the Piecewise Exponential Hazard (PEH) Cox model with a treatment indicator and returns a list containing posterior parameters and posterior restricted mean survival.
#' @param Y Vector of event or censoring times.
#' @param I1 Vector of event indicators.
#' @param Trt Vector containing patient treatment/control assignment.
#' @param Poi Prior mean number of split points.
#' @param B Number of iterations for MCMC.
#' @return Returns a list containing posterior samples of (1) the split point locations, (2) the log-hazards at each split point, (3) the number of split points, (4) the variance parameter for the log-hazard values, (5) the treatment coefficient, (6) the mean restricted survivial time of the control therapy, (7) the mean restricted survival time of the treatment therapy.
#' @examples
#' ##Generate Data
#' Y=rweibull(20,4,1)
#' I=rbinom(20,1,.5)
#' Trt=rbinom(20,1,.5)
#' ##Hyperparameter for number of split points
#' Poi=5
#'##Number of iterations for MCMC
#'B=200
#'BayesPiecewiseLinearLogHazardTrt( Y, I,Trt, Poi,  B)
#'@export
BayesPiecewiseLinearLogHazardTrt <- function(Y, I1, Trt, Poi, B) {
    .Call('_BayesReversePLLH_BayesPiecewiseLinearLogHazardTrt', PACKAGE = 'BayesReversePLLH', Y, I1, Trt, Poi, B)
}

#' Samples from the PEH Cox model with a patient covariate vector.
#'
#' Samples from the Piecewise Linear Log-Hazard (PLLH) Cox model and returns a list containing posterior parameters and posterior restricted mean survival.
#' @param Y Vector of event or censoring times.
#' @param I1 Vector of event indicators.
#' @param Trt Vector containing patient treatment/control assignment.
#' @param Poi Prior mean number of split points.
#' @param B Number of iterations for MCMC.
#' @return Returns a list containing posterior samples of (1) the split point locations, (2) the log-hazards at each split point, (3) the number of split points, (4) the variance parameter for the log-hazard values, (5) the treatment coefficient, (6) the mean restricted survivial time of the control therapy, (7) the mean restricted survival time of the treatment therapy.
#' @examples
#' ##Generate Data
#' Y=rweibull(20,4,1)
#' I=rbinom(20,1,.5)
#' Trt=rbinom(20,1,.5)
#' ##Hyperparameter for number of split points
#' Poi=5
#'##Number of iterations for MCMC
#'B=200
#'BayesPiecewiseHazardTrt( Y, I,Trt, Poi,  B)
#'@export
BayesPiecewiseHazardTrt <- function(Y, I1, Trt, Poi, B) {
    .Call('_BayesReversePLLH_BayesPiecewiseHazardTrt', PACKAGE = 'BayesReversePLLH', Y, I1, Trt, Poi, B)
}

#' Samples from the PEH Cox model with a patient covariate vector.
#'
#' Samples from the Piecewise Exponential Hazard (PEH) Cox model with a patient covariate vector and returns a list containing posterior parameters and posterior restricted mean survival.
#' @param Y Vector of event or censoring times.
#' @param I1 Vector of event indicators.
#' @param COV Matrix of size nxp containing p patient covariates.
#' @param Poi Prior mean number of split points.
#' @param B Number of iterations for MCMC.
#' @return Returns a list containing posterior samples of (1) the split point locations, (2) the log-hazards at each split point, (3) the number of split points, (4) the variance parameter for the log-hazard values, (5) the coefficients in the Cox model.
#' @examples
#' ##Generate Data
#' Y=rweibull(20,4,1)
#' I=rbinom(20,1,.5)
#' COV = matrix(rnorm(40,0,1),ncol=2)
#' ##Hyperparameter for number of split points
#' Poi=5
#'##Number of iterations for MCMC
#'B=200
#'BayesPiecewiseHazardCOV( Y, I,COV, Poi,  B)
#'@export
BayesPiecewiseHazardCOV <- function(Y, I1, COV, Poi, B) {
    .Call('_BayesReversePLLH_BayesPiecewiseHazardCOV', PACKAGE = 'BayesReversePLLH', Y, I1, COV, Poi, B)
}

#' Samples from the PLLH Cox model with a patient covariate vector.
#'
#' Samples from the Piecewise Linear Log-Hazard (PLLH) Cox model with a patient covariate vector and returns a list containing posterior parameters and posterior restricted mean survival.
#' @param Y Vector of event or censoring times.
#' @param I1 Vector of event indicators.
#' @param COV Matrix of size nxp containing p patient covariates.
#' @param Poi Prior mean number of split points.
#' @param B Number of iterations for MCMC.
#' @return Returns a list containing posterior samples of (1) the split point locations, (2) the log-hazards at each split point, (3) the number of split points, (4) the variance parameter for the log-hazard values, (5) the coefficients in the Cox model.
#' @examples
#' ##Generate Data
#' Y=rweibull(20,4,1)
#' I=rbinom(20,1,.5)
#' COV = matrix(rnorm(40,0,1),ncol=2)
#' ##Hyperparameter for number of split points
#' Poi=5
#'##Number of iterations for MCMC
#'B=200
#'BayesPiecewiseLinearLogHazardCOV( Y, I,COV, Poi,  B)
#'@export
BayesPiecewiseLinearLogHazardCOV <- function(Y, I1, COV, Poi, B) {
    .Call('_BayesReversePLLH_BayesPiecewiseLinearLogHazardCOV', PACKAGE = 'BayesReversePLLH', Y, I1, COV, Poi, B)
}

#' Samples from the PEH model without covariates.
#'
#' Samples from the Piecewise Exponential Hazard (PEH) model and returns a list containing posterior parameters and posterior restricted mean survival.
#' @param Y Vector of event or censoring times.
#' @param I1 Vector of event indicators.
#' @param Poi Prior mean number of split points.
#' @param B Number of iterations for MCMC.
#' @return Returns a list containing posterior samples of (1) the split point locations, (2) the log-hazards at each split point, (3) the number of split points, (4) the variance parameter for the log-hazard values, (5) the posterior mean restricted survivial time.
#' @examples
#' ##Generate Data
#' Y=rweibull(20,4,1)
#' I=rbinom(20,1,.5)
#' ##Hyperparameter for number of split points
#' Poi=5
#'##Number of iterations for MCMC
#'B=200
#'BayesPiecewiseHazard( Y, I, Poi,  B)
#'@export
BayesPiecewiseHazard <- function(Y, I1, Poi, B) {
    .Call('_BayesReversePLLH_BayesPiecewiseHazard', PACKAGE = 'BayesReversePLLH', Y, I1, Poi, B)
}

#' Samples from the PLLH model without covariates.
#'
#' Samples from the Piecewise Linear Log-Hazard (PLLH) model and returns a list containing posterior parameters and posterior restricted mean survival.
#' @param Y Vector of event or censoring times.
#' @param I1 Vector of event indicators.
#' @param Poi Prior mean number of split points.
#' @param B Number of iterations for MCMC.
#' @return Returns a list containing posterior samples of (1) the split point locations, (2) the log-hazards at each split point, (3) the number of split points, (4) the variance parameter for the log-hazard values, (5) the posterior mean restricted survivial time.
#' @examples
#' ##Generate Data
#' Y=rweibull(20,4,1)
#' I=rbinom(20,1,.5)
#' ##Hyperparameter for number of split points
#' Poi=5
#'##Number of iterations for MCMC
#'B=200
#'BayesPiecewiseLinearLogHazard( Y, I, Poi,  B)
#'@export
BayesPiecewiseLinearLogHazard <- function(Y, I1, Poi, B) {
    .Call('_BayesReversePLLH_BayesPiecewiseLinearLogHazard', PACKAGE = 'BayesReversePLLH', Y, I1, Poi, B)
}

