% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{BayesPiecewiseHazardCOV}
\alias{BayesPiecewiseHazardCOV}
\title{Samples from the PEH Cox model with a patient covariate vector.}
\usage{
BayesPiecewiseHazardCOV(Y, I1, COV, Poi, B)
}
\arguments{
\item{Y}{Vector of event or censoring times.}

\item{I1}{Vector of event indicators.}

\item{COV}{Matrix of size nxp containing p patient covariates.}

\item{Poi}{Prior mean number of split points.}

\item{B}{Number of iterations for MCMC.}
}
\value{
Returns a list containing posterior samples of (1) the split point locations, (2) the log-hazards at each split point, (3) the number of split points, (4) the variance parameter for the log-hazard values, (5) the coefficients in the Cox model.
}
\description{
Samples from the Piecewise Exponential Hazard (PEH) Cox model with a patient covariate vector and returns a list containing posterior parameters and posterior restricted mean survival.
}
\examples{
##Generate Data
Y=rweibull(20,4,1)
I=rbinom(20,1,.5)
COV = matrix(rnorm(40,0,1),ncol=2)
##Hyperparameter for number of split points
Poi=5
##Number of iterations for MCMC
B=200
BayesPiecewiseHazardCOV( Y, I,COV, Poi,  B)
}
