% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_EAP_CI.R
\name{extract_EAP_CI}
\alias{extract_EAP_CI}
\title{MRMC: Extract  Estimates of a vector from stanfitExtended object}
\usage{
extract_EAP_CI(StanS4class, parameter.name, dimension.of.parameter,
  dig = 5, summary = TRUE)
}
\arguments{
\item{StanS4class}{An S4 class object. The Name of S4 class is stanfit. No need that it is stanfitExtended s4 class.}

\item{parameter.name}{E.g., use as "aaa" . for names of parameter described in the parameter block.}

\item{dimension.of.parameter}{If parameter \code{aaa} is vector,
i.e.,\code{aaa[1],aaa[2],...aaa[6]} then you should put \code{dimension.of.parameter = 6}}

\item{dig}{An argument of \code{rstan::stan()} in which it is named \code{iter}.  It means the Significant digits, used in stan Cancellation.
default = 5,}

\item{summary}{TRUE or FALSE. If TRUE then summary and estimates are printed in the R console. If FALSE, the output is minimal.}
}
\value{
EAPs, CI.
}
\description{
We extract the EAPs and CIs from the stanfitExtended S4 class which is an
inherited class of the stanfit S4 class.
}
\details{
To validate our model has no bias,
that is comparison of true parameters of distributions and EAPs,
we have to extract the estimates from the stanfitExtended object.
And this function do it.
}
\examples{

\donttest{
# First we create the stanfitExtend class object.

   fit <- fit_Bayesian_FROC(BayesianFROC::dataList.Chakra.Web.orderd,
   ite = 1111,
   summary = FALSE)


# Second, to extract the EAPs of the parameter z,
# we also have to specify its dimension as an array as follows.

       extract_EAP_CI(fit,"z",5)

# Second, to extract the EAPs of the parameter dz,
#     we also have to specify its dimension as an array as follows.

      list.of.dz <-extract_EAP_CI(fit,"dz",4)

           list.w  <-extract_EAP_CI(fit,"w",1)


#    Note that this function can extract
#      only parameter of vector and not "array" !!
#     To extract such array please use "extract_estimates_MRMC()"
#      which extract all parameters from a hierarchical Bayesian model
#       estimated from user data.
# So, this function is no longer meaningful, and I will delete this.
}# dottest



}
\seealso{
extract_estimates_MRMC
}
