% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stanfitExtended.R
\docType{class}
\name{stanfitExtended}
\alias{stanfitExtended}
\title{stanfitExtended  (S4 class)}
\description{
Inherits from the class \strong{\emph{\code{\link[rstan]{stanfit}}}}.

   Note that  \strong{\emph{\code{\link[rstan]{stanfit}}}}  is an S4 class defined in  the package \strong{\emph{rstan }} :
}
\section{Slots}{

\describe{
\item{\code{plotdataMRMC}}{Plot data for MRMC case.}

\item{\code{plotdata}}{This is a data frame with four components which is used to draw curves such as FROC curves and AFROC curves.}

\item{\code{dataList}}{This is a dataset. Using the dataset, the fitting has done.}

\item{\code{studyDesign}}{This is character, e.g., "srsc.per.image",  "srsc.per.lesion",}

\item{\code{metadata}}{This is additional data calculated from dataList, such as cumulative hits and false alarms,...,etc.}

\item{\code{WAIC}}{This is a WAIC calculated by the function \strong{\emph{\code{\link{waic}}}} .}

\item{\code{convergence}}{This is TRUE or FALSE. If TRUE, then it means your model is good in the R hat criterion.}

\item{\code{PreciseLogLikelihood}}{This is TRUE or FALSE. If TRUE, then target formulation is used in the stan file.}

\item{\code{chisquare}}{This is a chi square calculated with Expected A Posterior estimates, i.e., the posterior mean estimates. Note that this is \emph{not} calculated by integrating the posterior predictive measure. Do not confuse with the p value calculated with the posterior predicitive measure implemented in the function \code{\link{p_value_of_the_Bayesian_sense_for_chi_square_goodness_of_fit}()}}

\item{\code{index}}{THis is for programming phase.}

\item{\code{Divergences}}{This is a number of the divergence transitions in the MCMC simulation.}

\item{\code{MCMC.Iterations}}{A MCMC iterations which does not count the burn-in period.}

\item{\code{Divergence.rate}}{A divergence rate, that is the number of the divergence iterations over total MCMC iterations. Burn-in period is not included.}

\item{\code{model_name}}{This is a slot from the \strong{\emph{\code{\link[rstan]{stanfit}}}} which is an S4 class defined in the \strong{\emph{rstan }}package.}

\item{\code{model_pars}}{This is a slot from the \strong{\emph{\code{\link[rstan]{stanfit}}}} which is an S4 class defined in the \strong{\emph{rstan }}package.}

\item{\code{par_dims}}{This is a slot from the \strong{\emph{\code{\link[rstan]{stanfit}}}} which is an S4 class defined in the \strong{\emph{rstan }}package.}

\item{\code{mode}}{This is a slot from the \strong{\emph{\code{\link[rstan]{stanfit}}}} which is an S4 class defined in the \strong{\emph{rstan }}package.}

\item{\code{sim}}{This is a slot from the \strong{\emph{\code{\link[rstan]{stanfit}}}} which is an S4 class defined in the \strong{\emph{rstan }}package.}

\item{\code{inits}}{This is a slot from the \strong{\emph{\code{\link[rstan]{stanfit}}}} which is an S4 class defined in the \strong{\emph{rstan }}package.}

\item{\code{stan_args}}{This is a slot from the \strong{\emph{\code{\link[rstan]{stanfit}}}} which is an S4 class defined in the \strong{\emph{rstan }}package.}

\item{\code{stanmodel}}{This is a slot from the \strong{\emph{\code{\link[rstan]{stanfit}}}} which is an S4 class defined in the \strong{\emph{rstan }}package.}

\item{\code{date}}{This is a slot from the \strong{\emph{\code{\link[rstan]{stanfit}}}} which is an S4 class defined in the \strong{\emph{rstan }}package.}

\item{\code{.MISC}}{This is a slot from the \strong{\emph{\code{\link[rstan]{stanfit}}}} which is an S4 class defined in the \strong{\emph{rstan }}package.}
}}

