% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/validation_MRMC_Create_dataList_MRMC_Hit_from_rate_etc.R
\name{create_dataList_MRMC}
\alias{create_dataList_MRMC}
\title{MRMC: Only One Dataset Creator (No Replication, to do so, see \code{\link{replicate_MRMC_dataList}()})}
\usage{
create_dataList_MRMC(z.truth = BayesianFROC::z_truth,
  mu.truth = BayesianFROC::mu_truth, v.truth = BayesianFROC::v_truth,
  NI = 57, NL = 142, ModifiedPoisson = FALSE, seed = 123,
  summary = FALSE)
}
\arguments{
\item{z.truth}{Vector of dimension = C represents the thresholds of bi-normal assumption.}

\item{mu.truth}{array of dimension (M,Q).
Mean of represents the signal distribution
of bi-normal assumption.}

\item{v.truth}{array of dimension (M,Q).
Standard Deviation of represents the signal
 distribution of bi-normal assumption.}

\item{NI}{The number of images,}

\item{NL}{The number of lesions,}

\item{ModifiedPoisson}{Logical, that is \code{TRUE} or \code{FALSE}. If
\code{ModifiedPoisson = TRUE},
then Poisson rate of false alarm is calculated \emph{per lesion},
and model is fitted so that the FROC curve is a expected curve of TPF and FPF \emph{per lesion}.
If \code{ModifiedPoisson = FALSE}, then Poisson rate of false alarm is calculated \emph{per image},
and model is fitted so that the FROC curve is a expected curve of TPF and FPF \emph{per image}.
To know detail, see the author's paper in which I explained \emph{per image} and \emph{per lesion}.(for details of models, see   \href{https://cran.r-project.org/package=BayesianFROC}{ vignettes  })

If \code{ModifiedPoisson = TRUE},
 then the \emph{False Positive Fraction (FPF)} is calculated as follows
 (\eqn{f_c} denotes the number of false alarms with confidence level \eqn{c} )


\deqn{ \frac{f_1+f_2+f_3+f_4+f_5}{N_L}, }

\deqn{ \frac{f_2+f_3+f_4+f_5}{N_L}, }

 \deqn{ \frac{f_3+f_4+f_5}{N_L}, }

  \deqn{ \frac{f_4+f_5}{N_L}, }

   \deqn{ \frac{f_5}{N_L}, }

where \eqn{N_L} is a number of lesions (signal).


On the other hand,


if \code{ModifiedPoisson = FALSE} (Default), then
\deqn{ \frac{f_1+f_2+f_3+f_4+f_5}{N_I}, }

\deqn{ \frac{f_2+f_3+f_4+f_5}{N_I}, }

 \deqn{ \frac{f_3+f_4+f_5}{N_I}, }

  \deqn{ \frac{f_4+f_5}{N_I}, }

   \deqn{ \frac{f_5}{N_I}, }

where \eqn{N_I} is a number of images (trial).


The model is fitted so that the estimated FROC curve is on the FPF per image or per lesion accordingly.

If \code{ModifiedPoisson = TRUE}, then FROC curve means the expected pair of FPF \strong{per lesion} and TPF.

On the other hand, if  \code{ModifiedPoisson = FALSE}, then FROC curve means the expected pair of \strong{FPF per image} and TPF.




So,data of FPF and TPF are changed thus, a fitted model is also changed whether  \code{ModifiedPoisson = TRUE} or \code{FALSE}.
In traditional FROC analysis, it uses only per images (trial). Since we can divide one image into two images or more images, number of
trial is not important. And more important is per signal. So, the author also developed FROC theory to consider FROC analysis under per signal.
One can see that the FROC curve is rigid with respect to change of a number of images, so, it does not matter whether \code{ModifiedPoisson = TRUE} or \code{FALSE}.

Revised 2019 August 28}

\item{seed}{The seed for creating hits which are generated by the binomial distributions with the specified seed.}

\item{summary}{Logical: \code{TRUE} of \code{FALSE}. Whether to print the verbose summary, i.e., logical; If \code{TRUE} then verbose summary is printed in the \R console. If \code{FALSE}, the output is minimal. I regret, this variable name should be verbose.}
}
\description{
From model a given parameter, an MRMC data list (can be passed to \code{\link{fit_Bayesian_FROC}()}) are created, where model parameter is thresholds, mean and standard deviation of signal Gaussian.
}
\examples{
\donttest{
     dataList  <- create_dataList_MRMC()


     fit_Bayesian_FROC(dataList,summary = FALSE)


#  In the example, we use a default values for true parameters for
#  the distributions. The reason why the default values exists is difficulty
#  for the user who is not familiar with FROC data nor FROC model parameter regions.
#   So, in the Bayesian model is merely model for FROC data.
#   If user input the abnormal data, then the model does not fit nor converge
#   in the Hamiltonian Monte Carlo simulations.


    plot_FPF_and_TPF_from_a_dataset(create_dataList_MRMC() )



#----------------------------------------------------------------------------------------
#     plot various MRMC datasets with fixed signal distribution but change thresholds
#----------------------------------------------------------------------------------------




plot_FPF_and_TPF_from_a_dataset(create_dataList_MRMC( z.truth = c(0.1,
                                                                  0.2,
                                                                  0.3,
                                                                  0.4)
))

plot_FPF_and_TPF_from_a_dataset(create_dataList_MRMC( z.truth = c(-0.1,
                                                                  0.2,
                                                                  0.3,
                                                                  0.4)
))


plot_FPF_and_TPF_from_a_dataset(create_dataList_MRMC( z.truth = c(-1,
                                                                  0.2,
                                                                  0.3,
                                                                  0.4)
))


plot_FPF_and_TPF_from_a_dataset(create_dataList_MRMC( z.truth = c(-1,
                                                                  -0.2,
                                                                  -0.3,
                                                                  0.4)
))


plot_FPF_and_TPF_from_a_dataset(create_dataList_MRMC( z.truth = c(-1,
                                                                  0.2,
                                                                  0.3 )
))


plot_FPF_and_TPF_from_a_dataset(create_dataList_MRMC( z.truth = c(-1,
                                                                  1.2,
                                                                  2.3 )
))


plot_FPF_and_TPF_from_a_dataset(create_dataList_MRMC( z.truth = c(-1,
                                                                  -0.5,
                                                                  0,
                                                                  1.2,
                                                                  2.3,
                                                                  3.3,
                                                                  4)
))



plot_FPF_and_TPF_from_a_dataset(create_dataList_MRMC( z.truth = c(-1,
                                                                  -0.5,
                                                                  0,
                                                                  1.2,
                                                                  2.3,
                                                                  3.3,
                                                                  4,
                                                                  5,
                                                                  6)
))


plot_FPF_and_TPF_from_a_dataset(create_dataList_MRMC( z.truth = c(-1,
                                                                  -0.5,
                                                                  0,
                                                                  1.2,
                                                                  2.3,
                                                                  3.3,
                                                                  4,
                                                                  5,
                                                                  6,
                                                                  7)
))



plot_FPF_and_TPF_from_a_dataset(create_dataList_MRMC( z.truth = c(-1,
                                                                  -0.5,
                                                                  0,
                                                                  1.2,
                                                                  2.3,
                                                                  3.3,
                                                                  4,
                                                                  5,
                                                                  6,
                                                                  7,
                                                                  8,
                                                                  9,
                                                                  10)
))


}
}
\seealso{
\code{\link{chi_square_at_replicated_data_and_MCMC_samples_MRMC}()}
\code{\link{replicate_MRMC_dataList}()}
}
