% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_empirical_ROC_curves.R
\name{plot_empirical_ROC_curves}
\alias{plot_empirical_ROC_curves}
\title{Empirical ROC curve}
\usage{
plot_empirical_ROC_curves(
  Number_of_cases = 100,
  Number_of_non_cases = 100,
  frequencies_of_non_cases = stats::rmultinom(1, size = Number_of_cases, prob = c(0.1,
    0.2, 0.3, 0, 5)),
  frequencies_of_cases = stats::rmultinom(1, size = Number_of_non_cases, prob = c(0.4,
    0.3, 0.2, 0, 1))
)
}
\arguments{
\item{Number_of_cases}{Number_of_cases}

\item{Number_of_non_cases}{Number_of_non_cases}

\item{frequencies_of_non_cases}{frequencies_of_non_cases}

\item{frequencies_of_cases}{frequencies_of_cases}
}
\description{
Empirical ROC curve
}
\details{
Suppose that there is a \eqn{K} categories and data are drawn
from two multinomial distributions of size \eqn{n,m}.

 \deqn{h_1,h_2,...,h_K, \Sigma h_i = n,}

 \deqn{f_1,f_2,...,f_K,\Sigma f_i = m.}

 Then this plots the cumulative sums.
}
