% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cutoff.R
\name{remove_layers_cutoff_plot}
\alias{remove_layers_cutoff_plot}
\title{remove_layers_cutoff_plot
Remove layers from a cutoff plot. This is useful to show how different things
are calculated (e.g. Sensitivity)}
\usage{
remove_layers_cutoff_plot(cutoff_plot, delete_what, silent = TRUE)
}
\arguments{
\item{cutoff_plot}{A plot_cutoff() plot}

\item{delete_what}{Elements to delete (i.e. FP, FN, TP, TN)}

\item{silent}{TRUE do not show debug info}
}
\value{
a cutoff plot without the elements deleted
}
\description{
remove_layers_cutoff_plot
Remove layers from a cutoff plot. This is useful to show how different things
are calculated (e.g. Sensitivity)
}
\examples{
\dontrun{
PLOT = plot_cutoff(prevalence = 0.2)
remove_layers_cutoff_plot(PLOT$final_plot, delete_what = c("FN", "TP")) + 
ggplot2::labs(subtitle = "Specificity = TN/(TN+FP)")
}
}
