% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMarginals.R
\name{violinPlot}
\alias{violinPlot}
\title{Violin Plot}
\usage{
violinPlot(x, at, .range = 1, add = FALSE, horizontal = TRUE,
  which = "both", relToAt = "above", plotQBox = TRUE, plotMed = TRUE,
  col = "orangered", border = "black", lwd = par("lwd"),
  colQBox = "black", borderQBox = "black", colMed = "white",
  pchMed = 19, res = 500, main = "")
}
\arguments{
\item{x}{vector of values to plot}

\item{at}{position of the plot when add is TRUE}

\item{.range}{maximum height if horizontal or width if vertical of the plot when add is set to FALSE}

\item{add}{logical, determining whether the plot should be added to an existing plot window}

\item{horizontal}{logical, determining whether the plot should be horizontal, if FALSE the plot will be vertical}

\item{which}{string, either "both" for a classic violing plot, or "top" or "bottom" to plot only the half violin}

\item{relToAt}{string, one of "centered", "above", "below", "left", "right". Determining the relative position to at.}

\item{plotQBox}{logical, determining whether the quantile box should be plotted}

\item{plotMed}{logical, determining whether the median should be plotted}

\item{col}{color of the violin}

\item{border}{color of the border of the violin}

\item{lwd}{line width if the border of the violin}

\item{colQBox}{color of quantile box}

\item{borderQBox}{color of the border of the quantile box}

\item{colMed}{color of the median point}

\item{pchMed}{pch for median point}

\item{res}{"resolution" of the violin. Determining how many descrete points should be used to calculate the density kernel.}

\item{main}{header text, only applicable, if 'add' is FALSE}
}
\description{
Function to plot classic violin plots, as well as "half violin plots" (density plots).
}
\author{
Tankred Ott
}
