/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic.phyloclustering.statistics;

import dr.inference.model.Parameter;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class indicatorsStatistic
extends Statistic.Abstract
implements VariableListener {
    private Parameter indicators;
    public static final String INDICATORS_STATISTIC = "indicatorsStatistic";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String INDICATORS_STRING = "indicators";
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("indicators", Parameter.class)};

        @Override
        public String getParserName() {
            return indicatorsStatistic.INDICATORS_STATISTIC;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Parameter parameter = (Parameter)xMLObject.getElementFirstChild(INDICATORS_STRING);
            return new indicatorsStatistic(parameter);
        }

        @Override
        public String getParserDescription() {
            return "This element returns a statistic that shifts a matrix of locations by location drift in the first dimension.";
        }

        @Override
        public Class getReturnType() {
            return indicatorsStatistic.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public indicatorsStatistic(Parameter parameter) {
        this.indicators = parameter;
        parameter.addParameterListener(this);
    }

    @Override
    public int getDimension() {
        return this.indicators.getDimension();
    }

    @Override
    public double getStatisticValue(int n) {
        return this.indicators.getParameterValue(n);
    }

    @Override
    public String getDimensionName(int n) {
        String string = "indicators_" + n;
        return string;
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }
}

